//
//
//	LAP library memory exceptions
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPmemoryException.h"
#include "LAPerrors.h"



LAPmemoryException::LAPmemoryException(int32 w, const char* l, const char* v)
: LAPexception(w, l)
{
	varName = v;
}


LAPmemoryException::LAPmemoryException(LAPmemoryException& e)
: LAPexception(e.what, e.where)
{
	varName = e.varName;
}


LAPmemoryException::~LAPmemoryException()
{
}


void
LAPmemoryException::_Output(LAPtextBufferedOutput& out)
{
	LAPexception::_Output(out);
	if (varName)
		out << " on variable '" << varName << '\'';
//		printf(" on variable %s", varName);
}


void
LAPmemoryException::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << eol << flush;
//	printf("\n");
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPbadInit::LAPbadInit(const char* location, const char* var)
: LAPmemoryException(LAP_BAD_INIT, location, var)
{
}


LAPbadInit::LAPbadInit(LAPbadInit& e)
: LAPmemoryException(e.what, e.where, e.varName)
{
}


LAPbadInit::~LAPbadInit()
{
}


void
LAPbadInit::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": bad or no initialization before use." << eol << flush;
//	printf(": bad or no initialization before use.\n");
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPbadBufferWrite::LAPbadBufferWrite(const char* location, const char* var,
									ssize_t a, ssize_t l)
: LAPmemoryException(LAP_BUFFER_OVERFLOW, location, var)
{
	asked = a;
	limit = l;
}


LAPbadBufferWrite::LAPbadBufferWrite(LAPbadBufferWrite& e)
: LAPmemoryException(e.what, e.where, e.varName)
{
	asked = e.asked;
	limit = e.limit;
}


LAPbadBufferWrite::~LAPbadBufferWrite()
{
}


void
LAPbadBufferWrite::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": bad buffer write of " << asked << " byte";
	if (asked > 1)
		out << 's';
	out << ", only " << limit << " available." << eol << flush;
//	printf(": bad buffer write of %d bytes, only %d available.\n", asked, limit);
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPbadBufferRead::LAPbadBufferRead(const char* location, const char* var,
									ssize_t a, ssize_t l)
: LAPmemoryException(LAP_BAD_READ, location, var)
{
	asked = a;
	left = l;
}


LAPbadBufferRead::LAPbadBufferRead(LAPbadBufferRead& e)
: LAPmemoryException(e.what, e.where, e.varName)
{
	asked = e.asked;
	left = e.left;
}


LAPbadBufferRead::~LAPbadBufferRead()
{
}


void
LAPbadBufferRead::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": bad buffer read of " << asked << " byte";
	if (asked > 1)
		out << 's';
	out << ", only " << left << " remaining." << eol << flush;

//	printf(": bad buffer read of %d bytes, only %d remaining.\n", asked, left);
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPbadAlloc::LAPbadAlloc(const char* location, const char* var, ssize_t a)
: LAPmemoryException(LAP_BUFFER_OVERFLOW, location, var)
{
	asked = a;
}


LAPbadAlloc::LAPbadAlloc(LAPbadAlloc& e)
: LAPmemoryException(e.what, e.where, e.varName)
{
	asked = e.asked;
}


LAPbadAlloc::~LAPbadAlloc()
{
}


void
LAPbadAlloc::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": can't allocate " << asked << " byte";
	if (asked > 1)
		out << 's';
	out << '.' << eol << flush;
//	printf(": can't allocate %d bytes.\n", asked);
}
