//
//
//	LAP binary parser class
//
//										(C) JoOl 1998


#ifndef _LAP_BIN_PARSER_H_
#define _LAP_BIN_PARSER_H_


#include "LAPparser.h"
#include "LAPbinLexer.h"



class						LAPbinParser: public LAPparser
{
protected:

//#if __POWERPC__
#pragma export on
//#endif
	LAPbinLexer*			lexer;

	void					SetLexer(LAPbinLexer* );

	void					ReadInt8(int8& ); // throw (LAPloadAborted);
	void					ReadInt8(uint8& ); // throw (LAPloadAborted);
	void					ReadInt16(int16& ); // throw (LAPloadAborted);
	void					ReadInt16(uint16& ); // throw (LAPloadAborted);
	void					ReadInt32(int32& ); // throw (LAPloadAborted);
	void					ReadInt32(uint32& ); // throw (LAPloadAborted);
	void					ReadInt64(int64& ); // throw (LAPloadAborted);
	void					ReadInt64(uint64& ); // throw (LAPloadAborted);
	void					ReadFloat(float& ); // throw (LAPloadAborted);
	void					ReadDouble(double& ); // throw (LAPloadAborted);
	void					ReadBytes(char* , int32 ); // throw (LAPloadAborted);
	void					ReadString(char* , int32 ); // throw (LAPloadAborted);
	void					SkipBytes(int32 ); // throw (LAPloadAborted);

public:
							LAPbinParser();
	virtual					~LAPbinParser();

	virtual status_t		SetInput(entry_ref , uint8 );

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_BIN_PARSER_H_ */

