//
//
//	LAP buffered-input class
//
//											(C) JoOl 1998


#ifndef _LAP_BUFFERED_INPUT_H_
#define _LAP_BUFFERED_INPUT_H_


#include "LAPdynBuffer.h"
#include "LAPfileException.h"
#include "LAPappliInterface.h"


class						LAPbufferedInput: public LAPdynBuffer
{
protected:

//#if __POWERPC__
#pragma export on
//#endif
	uint32					input;
	int32					inputMemorySize;
	int32					inputMemoryPtr;
	char*					inputMemory;

	BPath					inputFilePath;
	BFile*					inputFile;

	void					_badRead(char* , int32 );
	virtual void			badRead(char* , int32 );

	status_t				_ReadInput();

	LAPappliInterface*		appliInterface;

public:
							LAPbufferedInput(int32 );
	virtual					~LAPbufferedInput();

	void					SetAppliInterface(LAPappliInterface* );
	LAPappliInterface*		GetAppliInterface() const;

	status_t				SetNoInput();
	status_t				SetFileInput(const char* );
	void					UnsetFileInput();
	status_t				SetMemoryInput(char* , int32 );
	void					UnsetMemoryInput();

	off_t					GetInputSize() const;
	off_t					GetInputPosition() const;
	off_t					GetPosition() const;
	status_t				SetPosition(off_t); // throw (LAPbadSeek);
	char*					GetInputPath() const;
	char*					GetInputLeaf() const;

	bool					Eof() const;

	char					Read();
	void					Read(char& );
	void					Read(char* , int32 );
	virtual status_t		ReadInput();

	void					ReadString(char* , int32 );
	void					SkipBytes(off_t );
	void					Skip();

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_BUFFERED_INPUT_H_ */
