//
//
//	LAP buffered-output class
//
//											(C) JoOl 1998


#ifndef _LAP_BUFFERED_OUTPUT_H_
#define _LAP_BUFFERED_OUTPUT_H_


#include "LAPdynBuffer.h"



// Buffer-flush indicator
class						LAPbufferFlush {};
static LAPbufferFlush		flush;


class						LAPbufferedOutput: public LAPdynBuffer
{

protected:

#pragma export on
	bool					silent;
	uint8					policy;
	uint8					outputs;
	char					tmp[LAP_BUFFER_WORK_LEN+1];

	LAPmessageType			msgType;
	BFile					outputFile;
	BMessenger*				outputMessenger;
	BMessage*				outputMessage;

	status_t				_Append(char* , int32 );
	virtual void			badWrite(char* , int32 );

	virtual status_t		OutputScreen(char* , int32 ) = 0;
	virtual status_t		OutputFile(char* , int32 );
	virtual status_t		OutputBHandler(char* , int32 );


public:
							LAPbufferedOutput(int32 , uint8 , uint8 = LAP_BUFFER_NO_OUTPUT);
	virtual					~LAPbufferedOutput();

	void					SetSilent(bool );
	bool					IsSilent() const;
	uint8					GetOutputs() const;

	void					SetMessageType(LAPmessageType );
	status_t				SetNoOutput();
	status_t				SetScreenOutput();
	void					UnsetScreenOutput();
	status_t				SetFileOutput(char* , uint32 = B_WRITE_ONLY | B_FAIL_IF_EXISTS);
	void					UnsetFileOutput();
	status_t				SetBHandlerOutput(BHandler* , BLooper* , BMessage* );
	void					UnsetBHandlerOutput();

	void					Append(char* , int32 );
	void					Output(char* , int32 );

#pragma export reset
};


#endif	/* _LAP_BUFFERED_OUTPUT_H_ */
