//
//
//	LAP Parser class
//
//										(C) JoOl 1998


#ifndef _LAP_PARSER_H_
#define _LAP_PARSER_H_


#include "LAPlexer.h"
#include "LAPparserException.h"
#include "LAPtracer.h"
#include "LAPappliInterface.h"



enum
{
	LAP_OWN_NOTHING			= 0x00,
	LAP_OWN_ERROR_OUTPUT 	= 0x01,
	LAP_OWN_TRACE_OUTPUT 	= 0x02,
	LAP_OWN_DISPLAY			= 0x04
};


enum
{
	LAP_NO_TRACE			= 0x0,
	LAP_TRACE				= 0x1,
	LAP_ERRORS_TRACE		= 0x2
};


class						LAPparser
{

protected:

//#if __POWERPC__
#pragma export on
//#endif

	status_t				status;
	LAPlexer*				_lexer;
	LAPdisplay*				display;
	LAPtracer*				errorOutput;
	LAPtextBufferedOutput*	traceOutput;
	LAPappliInterface*		appliInterface;
	uint8					owned;

	void*					data;

	// parse-abort related stuff
	bool					abortRequested;
	BLocker					Locker;
	virtual status_t		DoAbort() = 0;

	status_t				Identify();
	virtual status_t		_Identify() = 0;
	virtual status_t		_Parse() = 0;
	virtual void			_Terminate();

	void					SetLexer(LAPlexer* );
	LAPlexer*				GetLexer() const;
	void					SetTo(	LAPtracer* ,		// error
									LAPtextBufferedOutput* ,
									LAPdisplay* ,
									uint8 = LAP_OWN_NOTHING);

	LAPsymbol*				Search(char* ) const;
	LAPsymbol*				SearchGlobal(char* ) const;
	LAPsymbol*				SearchLocal(char* ) const;
	status_t				Insert(LAPsymbol* );

	bool					Lock(); // throw (LAPloadAborted);
	void					Unlock(); // throw (LAPloadAborted);

	status_t				SetTraceFile(entry_ref , uint32 );
	status_t				SetMessagesTraceFile(entry_ref , uint32 );

public:
							LAPparser();
	virtual					~LAPparser();

	bool					LockNoThrow();
	void					UnlockNoThrow();
	bool					IsLocked();

	bool					CheckStatus() const;
	status_t				GetStatus() const;
	bool					Eof() const;

	LAPappliInterface*		GetAppliInterface() const;
	void					SetAppliInterface(LAPappliInterface* );

	LAPdisplay*				GetDisplay() const;

	LAPtracer*				GetErrorOutput() const;
	LAPtracer*				GetWarningOutput() const;
	LAPtracer*				GetInfoOutput() const;
	void					SetVerboseError(bool );
	LAPtextBufferedOutput*	GetTraceOutput() const;
	void					SetVerboseTrace(bool );

	bool					CheckTraceFile() const;
	bool					CheckErrorsTraceFile() const;

	void*					DetachData();

	virtual status_t		SetInput(entry_ref , uint8 ) = 0;
	virtual status_t		Parse(); // throw (LAPloadAborted);
	virtual void			Terminate();
	virtual void			Abort();

};


//#if __POWERPC__
#pragma export reset
//#endif
#endif	/* _LAP_PARSER_H_ */
