//
//
//	LAP Lexer class
//
//										(C) JoOl 1998

#include "LAPimpexp.h"

#include "LAPlexer.h"
#include "LAPerrors.h"
#include "LAPfileException.h"



LAPlexer::LAPlexer(LAPbufferedInput* in)
{
	if (!in)
		throw LAPbadInit("LAPlexer::LAPlexer", "input");

	_input = in;
	errorOutput = NULL;
	traceOutput = NULL;
	display = NULL;
	appliInterface = NULL;
}


LAPlexer::~LAPlexer()
{
	Terminate();
	delete _input;
}


void
LAPlexer::SetAppliInterface(LAPappliInterface* ai)
{
	appliInterface = ai;
	_input->SetAppliInterface(appliInterface);
}


LAPappliInterface*
LAPlexer::GetAppliInterface() const
{
	return appliInterface;
}


void
LAPlexer::Terminate()
{
	_input->SetNoInput();
	inputPath.Unset();
}


bool
LAPlexer::Eof() const
{
	return _input->Eof();
}


off_t
LAPlexer::GetPosition() const
{
	return _input->GetPosition();
}


off_t
LAPlexer::GetInputPosition() const
{
	return _input->GetInputPosition();
}


entry_ref
LAPlexer::GetInputRef() const
{
	return inputRef;
}


const char*
LAPlexer::GetInputName() const
{
	return inputPath.Leaf();
}


const char*
LAPlexer::GetInputPath() const
{
	return inputPath.Path();
}


void
LAPlexer::SetErrorOutput(LAPtracer* eo)
{
	if (!eo)
		throw LAPbadInit("LAPlexer::SetErrorOutput", "errorOutput");
	errorOutput = eo;
}


void
LAPlexer::SetTraceOutput(LAPtextBufferedOutput* to)
{
//	if (!to)
//		throw LAPbadInit("LAPlexer::SetTraceOutput", "traceOutput");
	traceOutput = to;
}


void
LAPlexer::SetDisplay(LAPdisplay* d)
{
	if (!d)
		throw LAPbadInit("LAPlexer::SetDisplay", "display");
	display = d;
}


status_t
LAPlexer::SetInput(entry_ref ref)
{
	// path
	BEntry			inputEntry(&ref, false);
	inputEntry.GetPath(&inputPath);

	// entry & file
	inputEntry.SetTo(&ref, true);
	inputEntry.GetRef(&inputRef);

	BFile			inputFile(&inputRef, B_READ_ONLY);
	if (inputFile.InitCheck() != B_NO_ERROR)
		return LAP_CANT_OPEN_FILE;

	struct stat			st;
	inputFile.GetStat(&st);
	if (!S_ISREG(st.st_mode))
		return LAP_NOT_A_FILE;

	status_t		s = _input->SetFileInput(inputPath.Path());
	if (s != LAP_NO_ERROR)
		return s;
	return _SetInput(inputRef);
}
