//
//
//	LAP symbol class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPsymbol.h"
#include "LAPsymbolDef.h"
#include "LAPsymbolType.h"



LAPsymbol::LAPsymbol(char* n, int32 l, int32 o)
{
	name = strdup(n);
	level = l;
	offset = o;
	def = NULL;
	type = NULL;
}


LAPsymbol::LAPsymbol(char* n, LAPdef* d, LAPtype* t)
{
	name = strdup(n);
	level = 0;
	offset = 0;
	def = d;
	type = t;
}


LAPsymbol::LAPsymbol(char* n, int32 l, int32 o, LAPdef* d, LAPtype* t)
{
	name = strdup(n);
	level = l;
	offset = o;
	def = d;
	type = t;
}


LAPsymbol::~LAPsymbol()
{
	delete[] name;
//	Are expected to be deleted as nodes of a symbol table
//	delete def;
//	delete type;
}


char*
LAPsymbol::GetName() const
{
	return name;
}


int32
LAPsymbol::GetLevel() const
{
	return level;
}


int32
LAPsymbol::GetOffset() const
{
	return offset;
}


LAPdef*
LAPsymbol::GetDef() const
{
	return def;
}


LAPtype*
LAPsymbol::GetType() const
{
	return type;
}


void
LAPsymbol::SetLevel(int32 l)
{
	level = l;
}


void
LAPsymbol::SetOffset(int32 o)
{
	offset = o;
}


void
LAPsymbol::SetDef(LAPdef* d)
{
	def = d;
}


void
LAPsymbol::SetType(LAPtype* t)
{
	type = t;
}
