//
//
//	Pierrot 3d matrix
//
//										(C) JoOl 1998


#ifndef _PIERROT_3D_MATRIX_H_
#define _PIERROT_3D_MATRIX_H_

#include "PierrotGeometry.h"



//--------------------------------------------------------
// 3d matrix
//--------------------------------------------------------

class					pMatrix3
{
#define PIERROT_MATRIX_SWAP(a, b) 	tmp = (a);	\
									(a) = (b);	\
									(b) = tmp;

	pVector3			mat[3];

public:

#pragma export on
						pMatrix3();
						pMatrix3(pMatrix3 &);
						pMatrix3(pVector3 &, pVector3 &, pVector3 &);
						~pMatrix3();

	void				SetX(pVector3& );
	void				SetY(pVector3& );
	void				SetZ(pVector3& );
	void				Set0(pVector3& );
	void				Set1(pVector3& );
	void				Set2(pVector3& );
	pVector3&			GetX();
	pVector3&			GetY();
	pVector3&			GetZ();

	void				Identity();
	void				Scale(float, float);
	void				Scale(float, float, float);
	void				Transpose();
	void				Translate(float, float);

	pMatrix3&			operator=(pMatrix3& );
	pMatrix3&			operator+=(pMatrix3& );
	pMatrix3&			operator-=(pMatrix3& );
	pMatrix3&			operator*=(float);
	pMatrix3&			operator/=(float);
	pMatrix3&			operator*=(pMatrix3& );

	pMatrix3	 		operator~();
	pMatrix3 			operator-();
	pMatrix3 			operator+(pMatrix3& );
	pMatrix3 			operator-(pMatrix3& );
	pMatrix3 			operator*(float);
	pMatrix3 			operator/(float);
	pMatrix3 			operator*(pMatrix3& );

	static pMatrix3		RotateX(float , float );
	static pMatrix3		RotateY(float , float );
	static pMatrix3		RotateZ(float , float );
	static pMatrix3		RotateToZ(pVector3& );

#pragma export reset
};


#endif /* _PIERROT_3D_MATRIX_H_ */
