//
//
//	Pierrot 4d matrix
//
//										(C) JoOl 1998


#ifndef _PIERROT_4D_MATRIX_H_
#define _PIERROT_4D_MATRIX_H_

#include "PierrotGeometry4.h"



//--------------------------------------------------------
// 4d matrix
//--------------------------------------------------------

class					pMatrix4
{
#define PIERROT_MATRIX_SWAP(a, b) 	tmp = (a);	\
									(a) = (b);	\
									(b) = tmp;

	pVector4			mat[4];

public:

#pragma export on
						pMatrix4();
						pMatrix4(pMatrix3& );
						pMatrix4(pMatrix3& , pVector3& );
						pMatrix4(pMatrix4& );
						pMatrix4(pVector4& , pVector4& , pVector4& , pVector4& );
						~pMatrix4();

	void				SetX(pVector4& );
	void				SetY(pVector4& );
	void				SetZ(pVector4& );
	void				SetW(pVector4& );
	void				Set0(pVector4& );
	void				Set1(pVector4& );
	void				Set2(pVector4& );
	void				Set3(pVector4& );
	pVector4&			GetX();
	pVector4&			GetY();
	pVector4&			GetZ();
	pVector4&			GetW();

	void				Identity();
	void				Scale(float, float, float );
	void				Scale(float, float, float, float );
	void				Transpose();
	void				Translate(float, float, float );

	pMatrix4&			operator=(pMatrix4& );
	pMatrix4&			operator+=(pMatrix4& );
	pMatrix4&			operator-=(pMatrix4& );
	pMatrix4&			operator*=(float);
	pMatrix4&			operator/=(float);
	pMatrix4&			operator*=(pMatrix4& );

	pMatrix4	 		operator~();
	pMatrix4 			operator-();
	pMatrix4 			operator+(pMatrix4& );
	pMatrix4 			operator-(pMatrix4& );
	pMatrix4 			operator*(float);
	pMatrix4 			operator/(float);
	pMatrix4 			operator*(pMatrix4& );

	static pMatrix4		RotateX4(float , float );
	static pMatrix4		RotateY4(float , float );
	static pMatrix4		RotateZ4(float , float );

#pragma export reset
};


#endif /* _PIERROT_4D_MATRIX_H_ */
