//
//
//	Pierrot object
//
//										(C) JoOl 1998


#ifndef _PIERROT_OBJECT_H_
#define _PIERROT_OBJECT_H_


#include <SupportDefs.h>
#include "PierrotColor.h"
#include "PierrotArray.h"
#include "PierrotVolume.h"
#include "PierrotMaterial.h"
#include "PierrotMatrix4.h"

#include "PierrotPtrArray.h"
#include "PierrotPointsArray.h"



//--------------------------------------------------------
// 3d line
//--------------------------------------------------------

class					pSegment
{
public:
	int32				start, end;

	pSegment()
	{
		start = end = -1;
	};
	pSegment(int32 s, int32 e)
	{
		start = s;
		end = e;
	};
	~pSegment()
	{};

	void				SetTo(int32 s, int32 e)
	{
		start = s;
		end = e;
	};
};


//--------------------------------------------------------
// 3d face
//--------------------------------------------------------

class					pFace
{
	void				Alloc(int32 );
public:

	pMaterial*			material;
	int32				vcount;
	int32*				index;

#pragma export on
						pFace();
						pFace(pMaterial* , int32 , int32 , int32 );
						pFace(pMaterial* , int32 , int32 , int32 , int32 );
						pFace(pMaterial* , int32 , int32* );
						pFace(pFace& );
						~pFace();

	void				SetTo(pMaterial* , int32 , int32 , int32 );
	void				SetTo(pMaterial* , int32 , int32 , int32 , int32 );
	void				SetTo(pMaterial* , int32 , int32* );
	void				SetTo(pFace& );

	pSpectra			GetSpectra();
	pColor				GetColor();

	inline int32		operator[] (int32 i)
	{ return index[i]; };
	inline bool			IsTriangle() const
	{ return vcount == 3; };
	inline bool			IsQuad() const
	{ return vcount == 4; };

	void				Reverse();

#pragma export reset
};


//--------------------------------------------------------
// 3d object
//--------------------------------------------------------

enum
{
	// polygonal data
	// vertices default values
	POLY_VERTICES_ALLOC = 256,
	POLY_VERTICES_BLOCK = 256,

	// faces default values
	POLY_FACES_ALLOC = 256,
	POLY_FACES_BLOCK = 256,

	// ponctual data
	// dots default values
	PONCT_VERTICES_ALLOC = 16,
	PONCT_VERTICES_BLOCK = 16,

	// dots default values
	PONCT_DOTS_ALLOC = 16,
	PONCT_DOTS_BLOCK = 16,

	// lines default values
	PONCT_LINES_ALLOC = 16,
	PONCT_LINBS_BLOCK = 16
};


class							pObject
{
public:
	char*						name;
	pBox						bounds;
	pSphere						sbounds;
	pMatrix4					matrix;

	// dots and lines data
	pPointsArray				dlVertices;
	PierrotArray<int32 >		dots;
	PierrotArray<pSegment >		lines;

	// polygonal data
	bool						ownVertices;
	pPointsArray*				vertices;
	pVectorsArray*				normals;
	pTexPointsArray				texVertices;
	PierrotPtrArray<pFace* >	faces;

	void*						misc;

#pragma export on

								pObject(char* );
								pObject(char* , int32 , int32 , int32 , int32 );
								pObject(char* , pPointsArray* , pVectorsArray* = NULL);
								~pObject();

	inline bool					HasVertices() const
	{ return vertices->CountItems() > 0; };
	inline bool					OwnVertices() const
	{ return ownVertices; };

	void						Transform(pMatrix4& );

	void						MoveBy(pVector3& );
	void						Rotate(pMatrix3& );
	void						ScaleBy(float );
	void						Mirror(pPlane& );
	pObject*					Dup(char* );
	void						ClearNormals();
	void						SetNormals();
	void						NormNormals();
	void						SetBounds();

#pragma export reset
};


#endif /* _PIERROT_OBJECT_H_ */

