//
//
//	Pierrot light
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <string.h>
#include "PierrotLight.h"



//--------------------------------------------------------
// Light
//--------------------------------------------------------

pLight::pLight(char* n)
{
	name = strdup(n);
	SetDefaultLight();
	flags = 0;
}


pLight::~pLight()
{ delete[] name; }


bool
pLight::IsOn() const
{
	return (flags & PLIGHT_OFF) == 0;
}


bool
pLight::IsOff() const
{
	return (flags & PLIGHT_OFF) != 0;
}


void
pLight::SetOn()
{
	flags &= ~PLIGHT_OFF;
}


void
pLight::SetOff()
{
	flags |= PLIGHT_OFF;
}


bool
pLight::IsDirectional() const
{ return false; }


bool
pLight::IsPositional() const
{ return false; }


bool
pLight::IsSpotlight() const
{ return IsDirectional() && IsPositional(); }


void
pLight::SetAmbientAndDiffuse(pSpectra& s)
{ ambient = diffuse = s; }


void
pLight::SetAttenuation(float c, float l, float q)
{
	constantAttenuation = c;
	linearAttenuation = l;
	quadraticAttenuation = q;
}


void
pLight::SetDefaultLight()
{
	ambient = diffuse = specular = pSpectra(0.0, 0.0, 0.0);
	constantAttenuation = 1.0;
	linearAttenuation = quadraticAttenuation = 0.0;
}


void
pLight::MoveBy(pVector3& /*t*/)
{}


void
pLight::ScaleBy(float /*s*/)
{}



//--------------------------------------------------------
// Directional light
//--------------------------------------------------------

pDirectionalLight::pDirectionalLight(char* n, pVector3& d)
: pLight(n)
{ direction = d; }


pDirectionalLight::~pDirectionalLight()
{}


bool
pDirectionalLight::IsDirectional() const
{ return true; }



//--------------------------------------------------------
// Positional light
//--------------------------------------------------------

pPositionalLight::pPositionalLight(char* n, pPoint3& p)
: pLight(n)
{ position = p; }


pPositionalLight::~pPositionalLight()
{}


bool
pPositionalLight::IsPositional() const
{ return true; }


void
pPositionalLight::MoveBy(pVector3& t)
{
	pPoint3			pt(t.x, t.y, t.z);
//	position -= pt;
	position += pt;
}


void
pPositionalLight::ScaleBy(float s)
{ position *= s; }



//--------------------------------------------------------
// Spotlight
//--------------------------------------------------------

pSpotlight::pSpotlight(char* n, pPoint3& pos, pVector3& dir, float exp, float coff)
: pPositionalLight(n, pos)
{
	spotDirection = dir;
	spotExponent = max_c(0.0, exp);				// >= 0.0
	spotCutOff = min_c(max_c(coff, 0.0), 90.0);	// between 0.0 and 90.0
}


pSpotlight::~pSpotlight()
{}

