//
//
//	Am@chi window
//
//											(C) JoOl 1998


#include <Application.h>
#include <Window.h>
#include <MenuBar.h>
#include <Menu.h>
#include <MenuItem.h>
#include <Box.h>
#include <Button.h>
#include "AmachiWindow.h"
#include "LAPerrors.h"
#include "AmachiDefs.h"


AmachiWindow::AmachiWindow(BRect frame, const char* name, window_look look,
							window_feel feel, uint32 flags, uint32 wkspaces)
:BWindow(frame, name, look, feel, flags, wkspaces),
 currentRender(NULL)
{
	BRect			fr;

	// amachi background view
	fr = Bounds();
	BView*				bgv = new BView(fr, "Am@chi_bg", B_FOLLOW_ALL,
										B_WILL_DRAW | B_FRAME_EVENTS);
	bgv->SetViewColor(220, 220, 220, 0);
	this->AddChild(bgv);

	// menu bar
	BMenuBar*			menubar;
	BMenu*				menu;
	BMenuItem*			menu_item;

	fr = bgv->Bounds();
	fr.bottom = fr.top + 40.0;
	menubar = new BMenuBar(fr, "menubar", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
							B_ITEMS_IN_ROW, true);
	bgv->AddChild(menubar);

	// File menu
	menu = new BMenu("File");
//	msg = new BMessage(AMACHI_LOAD_SCENE);
	menu_item = new BMenuItem("Open", NULL, 'O');
	menu_item->SetEnabled(false);
//	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	menu->AddSeparatorItem();

	menu_item = new BMenuItem("About...", new BMessage(AMACHI_ABOUT_MSG), 'A');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	menu->AddSeparatorItem();

	menu_item = new BMenuItem("Quit", new BMessage(B_QUIT_REQUESTED), 'Q');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);
	menubar->AddItem(menu);


	// Window menu
	BMessage			msg(AMACHI_SHOW_WINDOW);
	msg.AddInt32("winId", 0);

	menu = new BMenu("Window");

	msg.ReplaceInt32("winId", AMACHI_MESSAGES_WINDOW);
	menu_item = new BMenuItem("Messages", new BMessage(&msg), 'M');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	msg.ReplaceInt32("winId", AMACHI_SETUP_WINDOW);
	menu_item = new BMenuItem("Setup", new BMessage(&msg), 'S');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	msg.ReplaceInt32("winId", AMACHI_OPENGL_WINDOW);
	menu_item = new BMenuItem("OpenGL", new BMessage(&msg), 'O');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	msg.ReplaceInt32("winId", AMACHI_LOADERS_WINDOW);
	menu_item = new BMenuItem("Loaders", new BMessage(&msg), 'L');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	menu->AddSeparatorItem();


	msg.what = AMACHI_SHOW_ALL_WINDOWS;
	menu_item = new BMenuItem("Show all", new BMessage(&msg), 'A');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	msg.what = AMACHI_HIDE_ALL_WINDOWS;
	menu_item = new BMenuItem("Hide all", new BMessage(&msg), 'H');
	menu_item->SetTarget(be_app);
	menu->AddItem(menu_item);

	menubar->AddItem(menu);


	BBox*			box;

	// list of scenes
	fr = bgv->Bounds();
	fr.InsetBy(10.0, 10.0);
	fr.top += 16.0;
	fr.bottom = fr.top + 140.0;
	box = new BBox(fr, "scenesBox", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
					B_WILL_DRAW | B_FRAME_EVENTS, B_FANCY_BORDER);
	bgv->AddChild(box);
	BuildScenesRoster(box);

	// OpenGL view
	fr = box->Frame();
	fr.OffsetBy(0.0, fr.Height() + 10.0);

	box = new BBox(fr, "OpenGLBox", B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
					B_WILL_DRAW | B_FRAME_EVENTS, B_FANCY_BORDER);

	fr = box->Bounds();
	fr.OffsetBy(0.0, 8.0);
	fr.InsetBy(5.0, 5.0);
	glConfig = new AmachiGLConfig(fr, "OpenGLConfig", B_FOLLOW_ALL,
									B_WILL_DRAW | B_FRAME_EVENTS);
	box->AddChild(glConfig);
	box->SetLabel(AMACHI_GLBOX_TITLE);
	bgv->AddChild(box);
	glBox = box;

	fr = Frame();
	SetSizeLimits(fr.Width(), 500.0, fr.Height(), fr.Height());
}


AmachiWindow::~AmachiWindow()
{
}


ScenesRoster*
AmachiWindow::GetScenesRoster() const
{
	return scenesRoster;
}


void
AmachiWindow::SetGLWindow(AmachiGLWindow* glw)
{
	glWin = glw;
}


bool
AmachiWindow::QuitRequested()
{
	be_app->PostMessage(B_QUIT_REQUESTED);
	return false;
}


void
AmachiWindow::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		be_app->PostMessage(msg);
		return;
	}

	BMessage			mm;
	SceneItem*			sceneItem = NULL;
	int32				itemIndex = -1;
	int32				all = -1;
	int32				winId = -1;

	switch (msg->what)
	{
		// scene-related messages
		case AMACHI_NEW_SCENE:
			msg->FindPointer("sceneItem", &sceneItem);
			if (sceneItem)
			{
//				sceneItem->GetScene()->viewsys.SetDefault();
				sceneItem->SetConfigView(glConfig);
				scenesRoster->AddItem(sceneItem);
				delAllScenesButton->SetEnabled(true);
			}
			break;

		case AMACHI_SELECT_SCENE:
			itemIndex = scenesRoster->CurrentSelection();
			if (itemIndex >= 0)
			{
				sceneItem = scenesRoster->ItemAt(itemIndex);
				renderSceneButton->SetEnabled((currentRender != sceneItem)
												& (itemIndex >= 0));
			}
			delSceneButton->SetEnabled(itemIndex >= 0);
			if (sceneItem)
			{
				printf("select %s\n", sceneItem->GetId());
			}
			break;

		case AMACHI_DELETE_SCENE:
			msg->FindInt32("all", &all);
			if (all > 0)
			{
				currentRender = NULL;
				scenesRoster->DeleteItems();
				delSceneButton->SetEnabled(false);
				delAllScenesButton->SetEnabled(false);
				sceneItem = currentRender;
			}
			else
			{
				itemIndex = scenesRoster->CurrentSelection();
				if (itemIndex >= 0)
				{
					sceneItem = scenesRoster->ItemAt(itemIndex);
					scenesRoster->DeleteItem(itemIndex);
					delSceneButton->SetEnabled(false);
				}
				if (scenesRoster->CountItems() < 1)
					delAllScenesButton->SetEnabled(false);
			}
			renderSceneButton->SetEnabled(false);
			glConfig->SetEnabled(scenesRoster->CountItems() > 0);
			if (currentRender == sceneItem)
			{
				glBox->SetLabel(AMACHI_GLBOX_TITLE);
				if (glWin->Lock())
				{
					glWin->SetTitle(AMACHI_WINDOW_TITLE);
					glWin->GetGLView()->Clear();
					glConfig->SetEnabled(false);
					glWin->Unlock();
				}
			}
			break;

		case AMACHI_RENDER_SCENE:
			itemIndex = scenesRoster->CurrentSelection();
			if (itemIndex >= 0)
			{
				sceneItem = scenesRoster->ItemAt(itemIndex);
				currentRender = sceneItem;
				renderSceneButton->SetEnabled(false);
				glBox->SetLabel(sceneItem->GetLabel());

				if (glWin->Lock())
				{
					BMessage		msg2(AMACHI_SHOW_WINDOW);
					msg2.AddInt32("winId", AMACHI_OPENGL_WINDOW);
					be_app->PostMessage(&msg2);

					glWin->SetTitle(sceneItem->GetLabel());
/*					if (glWin->IsHidden())
						glWin->Show();
					else
						glWin->Activate(true);
*/					glWin->GetGLView()->SetTo(	sceneItem->GetScene(),
												sceneItem->GetConfig(),
												sceneItem->GetConfigView());
					glWin->Unlock();
				}
			}
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	}
}


void
AmachiWindow::BuildScenesRoster(BBox* box)
{
	BRect			fr = box->Bounds();
	fr.InsetBy(10.0, 15.0);
	fr.OffsetBy(0.0, 2.0);
	fr.bottom -= 26.0;
	BListView*			lv = new BListView(fr, "scenesList", B_SINGLE_SELECTION_LIST,
										B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
										B_WILL_DRAW | B_FRAME_EVENTS);
	lv->SetSelectionMessage(new BMessage(AMACHI_SELECT_SCENE));
	scenesRoster = new ScenesRoster(lv, "scenesList", IL_SCROLL_ALL);
	box->AddChild(scenesRoster);
	box->SetLabel("Scenes");

	BMessage*			msg;

	msg = new BMessage(AMACHI_DELETE_SCENE);
	fr = scenesRoster->Frame();
	fr.OffsetBy(0.0, fr.Height() + 8.0);
	fr.SetRightBottom(BPoint(fr.left + 60.0, fr.top + 20.0));
	delSceneButton = new BButton(fr, "delSceneButton", "Delete", msg,
							B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	delSceneButton->SetEnabled(false);
	box->AddChild(delSceneButton);

	msg = new BMessage(AMACHI_DELETE_SCENE);
	msg->AddInt32("all", 1);
	fr.OffsetBy(fr.Width() + 10.0, 0.0);
	delAllScenesButton = new BButton(fr, "delAllScenesButton", "Delete all", msg,
							B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	delAllScenesButton->SetEnabled(false);
	box->AddChild(delAllScenesButton);

	msg = new BMessage(AMACHI_RENDER_SCENE);
	fr.OffsetBy(fr.Width() + 10.0, 0.0);
	renderSceneButton = new BButton(fr, "renderSceneButton", "Render", msg,
							B_FOLLOW_LEFT | B_FOLLOW_TOP, B_WILL_DRAW);
	renderSceneButton->SetEnabled(false);
	box->AddChild(renderSceneButton);
}
