//
//
//	Am@chi setup window
//
//											(C) JoOl 1998


#include <stdio.h>
#include <Application.h>
#include <Window.h>
#include <View.h>
#include <Box.h>
#include <TabView.h>
#include <StringView.h>
#include <NodeMonitor.h>

#include "AmachiDefs.h"
#include "SetupWindow.h"
#include "AmachiAddOn.h"
#include "AmachiGLConfig.h"


SetupWindow::SetupWindow(BRect frame, const char* name, window_look look,
							window_feel feel, uint32 flags, uint32 wkspaces)
: BWindow(frame, name, look, feel, flags, wkspaces)
{
	BRect			fr;

	// window's background view
	fr = Bounds();
	BView*				bgv = new BView(fr, "SetupWindow_bg", B_FOLLOW_ALL,
										B_WILL_DRAW | B_FRAME_EVENTS);
	bgv->SetViewColor(220, 220, 220, 0);
	this->AddChild(bgv);

	// TabView
	fr = Bounds();
	fr.InsetBy(5.0, 5.0);
	BTabView*			tabview;
	tabview = new BTabView(fr, "setup_tabview", B_WIDTH_AS_USUAL, B_FOLLOW_ALL,
												B_WILL_DRAW | B_FRAME_EVENTS);
	tabview->SetViewColor(220, 220, 220, 0);
	bgv->AddChild(tabview);

	BView*			view;
	BRect			frView = tabview->Bounds();
	frView.InsetBy(40.0, 28.0);
	frView.OffsetBy(-5.0, -13.0);

	// add-ons view
	view = new BView(frView, "add-onsView", B_FOLLOW_ALL, B_WILL_DRAW | B_FRAME_EVENTS);
	view->SetViewColor(bgv->ViewColor());

	fr = view->Bounds();
	fr.bottom = fr.top + 150.0;
	BListView*			lv0 = new BListView(fr, "addonsRoster", B_SINGLE_SELECTION_LIST,
											B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
											B_WILL_DRAW | B_FRAME_EVENTS);
	addonsRoster = new AddOnsRoster(lv0, "addonsRoster", IL_SCROLL_ALL);
	view->AddChild(addonsRoster);

	addonsTab = new BTab();
	tabview->AddTab(view, addonsTab);
	addonsTab->SetLabel("add-ons");

	fr = addonsRoster->Bounds();
	fr.OffsetBy(0.0, fr.Height() + 10.0);
	fr.bottom = fr.top + 20.0;
	addonsMonitorMessage = new BStringView(fr, "addonsPathString",
											AMACHI_MONITORED_LABEL,
											B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,
											B_WILL_DRAW);
	addonsMonitorMessage->SetAlignment(B_ALIGN_CENTER);
	view->AddChild(addonsMonitorMessage);

	// parameters view
	defaultParams = new ParamsSetupView(frView, "params_view", B_FOLLOW_ALL, B_WILL_DRAW | B_FRAME_EVENTS);
	defaultParams->SetViewColor(100, 100, 200, 0);
	paramsTab = new BTab();
	tabview->AddTab(defaultParams, paramsTab);
	paramsTab->SetLabel("params");

	tabview->Select(0);
}


SetupWindow::~SetupWindow()
{
}


AddOnsRoster*
SetupWindow::GetAddOnsRoster() const
{
	return addonsRoster;
}


int32
SetupWindow::LoadAddons(const char* path)
{
	if (addonsRoster->Explore(path, NewAmachiAddOn))
	{
		char*			tmp = new char[strlen(path) + strlen(AMACHI_MONITORED_LABEL) + 4 + 1];
		sprintf(tmp, "%s: %s", AMACHI_MONITORED_LABEL, path);
		addonsMonitorMessage->SetText(tmp);
		delete[] tmp;
	}

	return addonsRoster->CountItems();
}


bool
SetupWindow::QuitRequested()
{
	if (!IsHidden())
		Hide();
	return false;
}


void
SetupWindow::ReadFrom(GLconfig& conf)
{
	defaultParams->ReadFrom(conf);
}


void
SetupWindow::WriteTo(GLconfig& conf)
{
	defaultParams->WriteTo(conf);
}


void
SetupWindow::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		be_app->RefsReceived(msg);
		return;
	}

	switch(msg->what)
	{
		case B_NODE_MONITOR:
			NodeMonitor(msg);
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	}
}


void
SetupWindow::NodeMonitor(BMessage* msg)
{
	int32				opcode;
	if (msg->FindInt32("opcode", &opcode) != B_NO_ERROR)
		return ;

	PlainAddOn*			aoi;
	entry_ref			ref;
	node_ref			nref;
	const char*			name;

	switch(opcode)
	{
		case B_ENTRY_CREATED:
			msg->FindInt32("device", &ref.device);
			msg->FindInt64("directory", &ref.directory);
			msg->FindString("name", &name);
			ref.set_name(name);
			if (addonsRoster->Insert(ref, NewAmachiAddOn))
				printf("+ %s (creation)\n", name);
			else
				printf("+ error on creation of %s\n", name);
			break;

		case B_ENTRY_REMOVED:
			msg->FindInt32("device", &nref.device);
			msg->FindInt64("node", &nref.node);
			aoi = addonsRoster->Remove(nref);
			if (aoi)
			{
				printf("- %s (removed)\n", aoi->GetRef().name);
				delete aoi;
			}
			else
				printf("- error on item removal\n");
			break;

		case B_ENTRY_MOVED:
			msg->FindInt32("device", &ref.device);
			msg->FindInt64("from directory", &ref.directory);
			msg->FindString("name", &name);
			ref.set_name(name);
			if (!addonsRoster->Delete(ref))
			{
				msg->FindInt64("to directory", &ref.directory);
				if (addonsRoster->Insert(ref, NewAmachiAddOn))
					printf("+ %s (moved)\n", name);
				else
					printf("+ error moving item %s\n", name);
			}
			else
				printf("- %s (moved)\n", name);
			break;
	}
}
