//
//
//	View items list
//
//										(C) JoOl 1998


#ifndef _VIEW_ITEMS_LIST_H_
#define _VIEW_ITEMS_LIST_H_


#include <View.h>
#include <ListView.h>
#include <ScrollBar.h>
#include "PitemsList.h"
#include "Vitem.h"



class					VitemsList: public PitemsList
{
protected:

	BList				items;

	float				ComputeItemsWidth() const;


public:

						VitemsList(	BView* , const char* ,
									uint32 = IL_NO_SCROLL);
	virtual				~VitemsList();

	BRect				ItemFrame(int32 );
	void				MakeEmpty();
	void				DeleteItems();

	bool				IsEmpty() const;
	int32				CountItems() const;
	Vitem*				ItemAt(int32 ) const;
	int32				IndexOf(Vitem* ) const;
	int32				Search(Vitem* ) const;
	int32				Search(PitemsCmpFunc , void* ) const;
	bool				Exists(Vitem* ) const;
	bool				Exists(PitemsCmpFunc , void* ) const;
	bool				MoveItem(int32 , int32 );
	bool				SwapItems(int32 , int32 );

	bool				AddItem(Vitem* , int32 i = -1);
	bool				AddItem(PitemsCmpFunc , Vitem* , int32 i = -1);
	bool				DeleteItem(int32 );
	bool				DeleteItem(PitemsCmpFunc , void* );
	Vitem*				RemoveItem(int32 );
	Vitem*				RemoveItem(PitemsCmpFunc , void* );
};


#endif	/* _VIEW_ITEMS_LIST_H_ */
