//
//
//	Messages roster
//
//										(C) JoOl 1998


#include <string.h>
#include <stdio.h>
#include <SupportDefs.h>
#include <Application.h>
#include <Window.h>
#include <Bitmap.h>
#include "AmachiDefs.h"
#include "MessagesRoster.h"
#include "RiconedStringItem.h"


MessagesRoster::MessagesRoster(BListView* l, const char* n, uint32 sb)
: RitemsList(l, n, sb),
  idCounter(0),
  maxMessagesCount(5)
{
	*idLabel = 0;
}


MessagesRoster::~MessagesRoster()
{
}


void
MessagesRoster::AddItem(BBitmap* icon, char* msg)
{
	int32			len = strlen(msg);
	if (msg[len-1] == '\n')
		msg[len-1] = 0;
	sprintf(idLabel, "msg_%d\n", idCounter);
	idCounter++;
	while (CountItems() >= maxMessagesCount)
		DeleteItem(0);

	RiconedStringItem*		risi = new RiconedStringItem(idLabel, msg, icon, false);
	RitemsList::AddItem(risi);

	BRect			listFrame = _list->Frame();
	_list->ScrollTo(listFrame.left, listFrame.bottom);

	if (CountItems() == 1)
	{
		BMessage			msg(AMACHI_SHOW_WINDOW);
		msg.AddInt32("winId", AMACHI_MESSAGES_WINDOW);
		be_app->PostMessage(&msg);
	}
}


void
MessagesRoster::DeleteItem(int32 i)
{
	RitemsList::DeleteItem(i);

	if (CountItems() < 1)
		Window()->Hide();
}


void
MessagesRoster::DeleteItems()
{
	for (int32 i = CountItems()-1; i >= 0; i--)
		DeleteItem(i);

	Window()->Hide();
}
