//
//
//	Regular items list
//
//											(C) JoOl 1998

#include <string.h>
#include <stdio.h>
#include <ScrollBar.h>
#include "RitemsList.h"



RitemsList::RitemsList(BListView* lv, const char* n, uint32 sbars)
: PitemsList(lv, n, sbars)
{
	_list = lv;
}


RitemsList::~RitemsList()
{
	DeleteItems();
}


float
RitemsList::ComputeItemsWidth() const
{
	float			max = 0.0;
	for (int32 i = 0; i < itemsCount; i++)
	{
		Ritem*		itm = (Ritem* )_list->ItemAt(i);
		if (itm)
		{
			float		curr = itm->Width();
			if (curr > max)
				max = curr;
		}
	}
	return max;
}


BRect
RitemsList::ItemFrame(int32 index)
{
	return _list->ItemFrame(index);
}


void
RitemsList::MakeEmpty()
{
	_list->MakeEmpty();
}


void
RitemsList::DeleteItems()
{
	for (int32 i = 0; i < itemsCount; i++)
		delete (Ritem* )_list->ItemAt(i);
	_list->MakeEmpty();
}



void
RitemsList::MakeFocus(bool focus)
{
	_list->MakeFocus(focus);
}


void
RitemsList::ScrollTo(BPoint pt)
{
	_list->ScrollTo(pt);
}


void
RitemsList::ScrollToSelection()
{
	_list->ScrollToSelection();
}


int32
RitemsList::CurrentSelection(int32 i) const
{
	return _list->CurrentSelection(i);
}


void
RitemsList::Deselect(int32 i)
{
	_list->Deselect(i);
}


void
RitemsList::DeselectAll()
{
	_list->DeselectAll();
}


void
RitemsList::DeselectExcept(int32 start, int32 finish)
{
	_list->DeselectExcept(start, finish);
}


void
RitemsList::SetSelectionMessage(BMessage* msg)
{
	_list->SetSelectionMessage(msg);
}


void
RitemsList::SetInvocationMessage(BMessage* msg)
{
	_list->SetInvocationMessage(msg);
}


BMessage*
RitemsList::SelectionMessage() const
{
	return _list->SelectionMessage();
}


uint32
RitemsList::SelectionCommand() const
{
	return _list->SelectionCommand();
}


uint32
RitemsList::InvocationCommand() const
{
	return _list->InvocationCommand();
}


void
RitemsList::Select(int32 i, bool expand)
{
	_list->Select(i, expand);
}


void
RitemsList::Select(int32 start, int32 finish, bool expand)
{
	_list->Select(start, finish, expand);
}


bool
RitemsList::IsEmpty() const
{
	return _list->IsEmpty();
}


bool
RitemsList::IsItemSelected(int32 index) const
{
	return _list->IsItemSelected(index);
}


bool
RitemsList::AddItem(Ritem* item, int32 rank)
{
	return AddItem(Pitem::cmpPitems, item, rank);
}


bool
RitemsList::AddItem(PitemsCmpFunc func, Ritem* item, int32 rank)
{
	if (Search(func, item) >= 0)
		return false;

	if (rank < 0)
		rank = itemsCount;
	itemsCount++;
	_list->AddItem(item, rank);

	for (int32 i = rank; i < itemsCount; i++)
	{
		ItemAt(i)->SetViewColor(ColorFor(i));
		_list->InvalidateItem(i);
	}

	itemsHeight += item->Height();// - 1.0;	//---
	if (item->Width() > itemsWidth)
		itemsWidth = item->Width();

	UpdateScrollBars(itemsWidth, itemsHeight);

	return true;
}



int32
RitemsList::CountItems() const
{
	return itemsCount;
}


Ritem*
RitemsList::ItemAt(int32 i) const
{
	return (Ritem* )_list->ItemAt(i);
}


int32
RitemsList::IndexOf(Ritem* item) const
{
	return _list->IndexOf(item);
}


int32
RitemsList::IndexOf(BPoint pt) const
{
	return _list->IndexOf(pt);
}


int32
RitemsList::Search(Ritem* item) const
{
	return IndexOf(item);
}


int32
RitemsList::Search(PitemsCmpFunc func, void* data) const
{
	for (int32 i = 0; i < itemsCount; i++)
	{
		if (func((Ritem* )_list->ItemAt(i), data) == 0)
			return i;
	}
	return -1;
}


bool
RitemsList::Exists(Ritem* item) const
{
	return Search(item) >= 0;
}


bool
RitemsList::Exists(PitemsCmpFunc func, void* data) const
{
	return Search(func, data) >= 0;
}


bool
RitemsList::DeleteItem(int32 i)
{
	Ritem*			item = RemoveItem(i);
	if (!item)
		return false;
	delete item;
	return true;
}


bool
RitemsList::DeleteItem(PitemsCmpFunc func, void* data)
{
	Ritem*			item = RemoveItem(func, data);
	if (!item)
		return false;
	delete item;
	return true;
}


Ritem*
RitemsList::RemoveItem(int32 rank)
{
	Ritem*			item = (Ritem* )_list->RemoveItem(rank);
	if (item)
	{
		itemsWidth = ComputeItemsWidth();
		itemsHeight -= item->Height();// - 1.0;	//---
		itemsCount--;

		for (int32 i = rank; i < itemsCount; i++)
		{
			ItemAt(i)->SetViewColor(ColorFor(i));
			_list->InvalidateItem(i);
		}

		UpdateScrollBars(itemsWidth, itemsHeight);
	}
	return item;
}


Ritem*
RitemsList::RemoveItem(PitemsCmpFunc func, void* data)
{
	int32			rank = Search(func, data);
	if (rank < 0)
		return NULL;
	return RemoveItem(rank);
}
