//
//
//	Loaders roster
//
//										(C) JoOl 1998


#include "AmachiDefs.h"
#include "LoadersRoster.h"



LoadersRoster::LoadersRoster(BView* lv, const char* n, uint32 sbars)
: VitemsList(lv, n, sbars)
{
	maxRunningParsers = 2;
}


LoadersRoster::~LoadersRoster()
{
	StopLoaders();
}


bool
LoadersRoster::StopLoaders()
{
	if (LockLooper())
	{
		for (int32 i = 0; i < CountItems(); i++)
		{
			VloaderItem*		li = ItemAt(i);
			li->Stop();
		}
		UnlockLooper();
	}

	while (CountItems() > 0)
		snooze(100000.0);

	return true;
}


void
LoadersRoster::SetMaxRunningParsers(int32 n)
{
	maxRunningParsers = n;
}


int32
LoadersRoster::cmpLoaderItems(Pitem* itm, void* path)
{
	return strcmp(((VloaderItem* )itm)->GetId(), (char* )path);
}


int32
LoadersRoster::CountItems() const
{
	return VitemsList::CountItems();
}


VloaderItem*
LoadersRoster::ItemAt(int32 i) const
{
	return (VloaderItem* )VitemsList::ItemAt(i);
}


bool
LoadersRoster::Exists(entry_ref r) const
{
	BPath			path;
	BEntry			e(&r, true);
	e.GetPath(&path);
	return VitemsList::Exists(cmpLoaderItems, (char* )path.Path());
}


bool
LoadersRoster::AddItem(VloaderItem* item, int32 rank)
{
	if (!VitemsList::AddItem(cmpLoaderItems, item, rank))
		return false;

	if (CountItems() <= maxRunningParsers)
		item->Run();

	if (CountItems() == 1)
	{
		BMessage			msg(AMACHI_SHOW_WINDOW);
		msg.AddInt32("winId", AMACHI_LOADERS_WINDOW);
		be_app->PostMessage(&msg);
	}

	return true;
}


bool
LoadersRoster::RemoveItem(VloaderItem* item)
{
	int32			rank = -1;
	for (int32 i = 0; i < CountItems(); i++)
	{
		if ((void* )item == (void* )ItemAt(i))
		{
			rank = i;
			break ;
		}
	}
	if (rank < 0)
		return false;

	bool			out = VitemsList::RemoveItem(rank);
	RunNextLoader();

	if (CountItems() < 1)
		Window()->Hide();

	return out;
}


bool
LoadersRoster::RunNextLoader()
{
	// count running loaders and first waiting loader
	int32			toLaunch = -1;
	int32			count = 0;
	for (int32 i = 0; i < CountItems(); i++)
	{
		VloaderItem*		itm = ItemAt(i);
		if (itm->IsRunning() || itm->IsReady())
			count++;
		if (itm->IsWaiting() && (toLaunch < 0))
			toLaunch = i;
	}

	// if enough loaders running or no loader to be launched...
	if ((count >= maxRunningParsers) || (toLaunch < 0))
		return false;

	// launch loader
	ItemAt(toLaunch)->Run();
	return true;
}


void
LoadersRoster::MessageReceived(BMessage* msg)
{
	VloaderItem*			loader = NULL;
	pScene*					scn;
	BMessage				outmsg;
	msg->FindPointer("source", &loader);

	switch (msg->what)
	{
/*		case AMACHI_PLAY_LOADER:
			loader->Play();
			break ;

		case AMACHI_PAUSE_LOADER:
			loader->Pause();
			break ;
*/
		case AMACHI_STOP_LOADER:
			loader->Stop();
			break ;

		case AMACHI_DONE_LOADER:
			if (!RemoveItem(loader))
				printf("loader '%s' not found in loaders roster!?\n", loader->GetId());
			msg->FindPointer("scene", &scn);

			// send only if data (not aborted)
			if (scn)
			{
				outmsg.what = AMACHI_NEW_SCENE;
				outmsg.AddPointer("sceneItem", new SceneItem(loader->GetRef(), scn));
				be_app->PostMessage(&outmsg);
			}

			delete loader;
			break ;

		default:
			BView::MessageReceived(msg);
			break ;
	}
}
