//
//
//	GEOM lexer class
//
//											(C) JoOl 1998


#include "LexerGeom.h"



LexerGeom::LexerGeom(int32 blen, LAPlexemeBuffer* lb)
: LAPtextLexer(blen, lb)
{
}


LexerGeom::~LexerGeom()
{
}


LAPtoken
LexerGeom::_NextToken()
{
	for (;;)
	{
		if (input->Eof())
			return LAP_TOKEN_EOF;

		char			currentCharacter = input->Peek();

		// deal with numbers (both positive and negative integers or floats)
		if (IsDigit(currentCharacter) || (currentCharacter == '.'))
		{
			LexNumber();
			return token;
		}
		if (currentCharacter == '-')
		{
			Fwd();
			LexNumber();
			return token;
		}

		// deal with spaces
		if (IsSpace(currentCharacter))
		{
			SkipSpaces();
			continue;
		}

		ProcessIllegal(currentCharacter);
	}
}

