//
//
//	GEOM objects parser
//
//												(C) 1998 JoOl


#include "ParserGeom.h"



ParserGeom::ParserGeom(int32 blockSize, LAPtextParser* parent, pScene* scn)
: LAPtextParser()
{
	SetLexer(new LexerGeom(max_c(1024, blockSize), new LAPlexemeBuffer(128, true)));

	SetTo(parent->GetErrorOutput(),
			parent->GetTraceOutput(),
			parent->GetDisplay(),
			LAP_OWN_NOTHING);
	scene = scn;

	SetAppliInterface(parent->GetAppliInterface());
}


ParserGeom::~ParserGeom()
{
	// doesn't own the scene!
	scene = NULL;
}


status_t
ParserGeom::DoAbort()
{
	return LAP_NO_ERROR;
}


status_t
ParserGeom::_Identify()
{
	return LAP_NO_ERROR;
}


status_t
ParserGeom::_Parse()
{
	int32			nbVert;
	int32			nbFaces;
	int32			dummy;
	LexInt(nbVert);
	LexInt(nbFaces);
	LexInt(dummy);

	pMaterial*			defaultMaterial;
	defaultMaterial = scene->materials[scene->materials.Search("default material")];

	pObject*			object = NewObject(lexer->GetInputRef().name, nbVert, 0, nbFaces, 0);
	*traceOutput << "object " << object->name << eol << adv;

	*traceOutput << nbVert << " vertices" << eol << adv;
	for (int32 i = 0; i < nbVert; i++)
	{
		pPoint3			pt;
		ParseFloat(pt.x);
		ParseFloat(pt.y);
		ParseFloat(pt.z);

		Output(*traceOutput, pt);
		*traceOutput << eol;

		object->vertices->AddItem(pt);
	}

	*traceOutput << ret << nbFaces << " faces" << eol << adv;
	for (int32 i = 0; i < nbFaces; i++)
	{
		int32			nbv;
		LexInt(nbv);
		PierrotArray<int32 >	indexes(nbv, 1);

		*traceOutput << nbv;
		for (int32 j = 0; j < nbv; j++)
		{
			int32			index;
			LexInt(index);
			index--;
			indexes.AddItem(index);

			*traceOutput << ' ' << index;
		}
		*traceOutput << eol;

		object->faces.AddItem(new pFace(defaultMaterial, nbv, indexes.Items()));
	}
	*traceOutput << ret << ret;

	return LAP_NO_ERROR;
}
