//
//
//	IPCOL objects parser
//
//												(C) 1998 JoOl


#include "ParserIpcol.h"



ParserIpcol::ParserIpcol(int32 blockSize, LAPtextParser* parent, pScene* scn)
: LAPtextParser()
{
	SetLexer(new LexerGeom(max_c(1024, blockSize), new LAPlexemeBuffer(128, true)));

	SetTo(parent->GetErrorOutput(),
			parent->GetTraceOutput(),
			parent->GetDisplay(),
			LAP_OWN_NOTHING);
	scene = scn;

//	SetAppliInterface(parent->GetAppliInterface());
}


ParserIpcol::~ParserIpcol()
{
	// doesn't own the scene!
	scene = NULL;
}


status_t
ParserIpcol::DoAbort()
{
	return LAP_NO_ERROR;
}


status_t
ParserIpcol::_Identify()
{
	return LAP_NO_ERROR;
}


status_t
ParserIpcol::_Parse()
{
	int32			nbColors;
	int32			nbFaces = -1;
	LexInt(nbColors);
	SkipSpaces();
	if (lexer->GetLineNumber() == 1)
		LexInt(nbFaces);

	*traceOutput << nbColors << " materials" << eol << adv;
	if (nbFaces > 0)
	{
		for (int32 i = 0; i < nbColors; i++)
		{
			pSpectra			color;
			ParseFloat(color.r);
			ParseFloat(color.g);
			ParseFloat(color.b);

			char				buf[32];
			sprintf(buf, "material %d", scene->materials.CountItems());
			pMaterial*			material = NewMaterial(buf);
			material->ambient.Set(0.1, 0.1, 0.1);
			material->diffuse.Set(color);
			material->specular.Set(0.5, 0.5, 0.5);
			material->shininess = 40.0;

			Output(*traceOutput, color);
			*traceOutput << eol;
		}

		*traceOutput << ret << nbFaces << " faces" << eol << adv;
		pObject*			object = scene->objects[0];
		for (int32 i = 0; i < nbFaces; i++)
		{
			int32			colorIndex;
			LexInt(colorIndex);
			pMaterial*		material = scene->materials[colorIndex];
			object->faces[i]->material = material;

			*traceOutput << colorIndex << eol;
		}
	}
	else
	{
		for (int32 i = 0; i < nbColors; i++)
		{
			pSpectra			color;
			ParseFloat(color.r);
			ParseFloat(color.g);
			ParseFloat(color.b);

			pMaterial*			material = SearchMaterial(color);
			scene->objects[0]->faces[i]->material = material;

			Output(*traceOutput, color);
			*traceOutput << eol;
		}
	}

	*traceOutput << ret << ret;

	return LAP_NO_ERROR;
}


pMaterial*
ParserIpcol::SearchMaterial(pSpectra& col)
{
	int32			materialIndex = scene->materials.Search(col);
	if (materialIndex >= 0)
		return scene->materials[materialIndex];

	char				buf[32];
	sprintf(buf, "material %d", scene->materials.CountItems());
	pMaterial*			newMaterial = NewMaterial(buf);
	newMaterial->SetAmbientAndDiffuse(col);
	newMaterial->shininess = 60.0;
	return newMaterial;
}
