//
//
//	Dxf objects parser
//
//											(C) 1998 JoOl


#ifndef _PARSER_DXF_H_
#define _PARSER_DXF_H_


#include "LexerDxf.h"
#include "LAPtextParser.h"
#include "PierrotParser.h"


class						ParserDxf: public LAPtextParser, public PierrotParser
{
	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual status_t		DoAbort();


#define VERSION_R10			"AC1006"
#define VERSION_R11_R12		"AC1009"
#define VERSION_R13			"AC1012"
#define VERSION_R14			"AC1014"

	enum
	{
		DEFAULT_COLOR		= 9
	};

	int32					groupCode;

	pSpectra				palette[256];
	PierrotArray<uint8 >	layersColor;
//	PierrotArray<int32 >	layersGruik;

	// redefined next token, peeking & matching routines
	void					NextToken();
	void					Match(int32 );
	void					Match(int32 , LAPtoken );
	bool					Peek(int32 );
	bool					Peek(int32 , LAPtoken );
	void					GenerateMismatchGroupCodes(const char* , int32 , int32 );

	// a few useful methods
	void					MatchGroup(int32 , int32& );
	void					MatchGroup(int32 , float& );
	void					MatchGroupCast(int32 , float& );
	void					MatchGroup(int32 , char*& );
	void					MatchGroupCast(int32 , char*& );
	void					PrintGroup(int32 , LAPtoken );
	void					ParseTo(int32 );
	void					ParseTo(int32 , LAPtoken );

	// parsing routines
	void					ParsePoint(int32 , pPoint3& );
	void					ParseVector(int32 , pVector3& );

	// Header-related routines
	void					ParseHeader();
	void					ParseVersion();

	// Table-related routines
	void					ParseTables();
	void					ParseTable();
	void					ParseLayers();
	void					ParseLayer();
	void					ParseView();
	void					ParseAppId();

	// Entities-related routines
	void					ParseEntities();
	void					ParseLine();
	void					ParsePoint();
	int32					ParseVertex();
	int32					ParseDotVertex();
	void					ParsePolyfaceVertex(int32& , int32& , int32& , int32& );
	void					ParseFace3d();
	void					ParsePolyline();


	int32					FindOrCreateLayer(char* );
	void					InitPalette();
	int32					NewVertex(char* , pPoint3& );
	int32					NewDot(char* , pPoint3& );
	int32					NewDotVertex(char* , pPoint3& );
	int32					NewLine(char* , pPoint3&, pPoint3& );
	void					NewFace(char* , pMaterial* , pPoint3& , pPoint3& , pPoint3& );
	void					NewFace(char* , pMaterial* , pPoint3& , pPoint3& , pPoint3& , pPoint3& );
	void					NewFace(char* , PierrotArray<int32 >& , int32 , int32 );

	int32					SearchMaterial(pSpectra& );

public:

							ParserDxf(int32 );
	virtual					~ParserDxf();
};



#if __POWERPC__
#pragma export on
#endif
extern "C" ParserDxf*		instantiate_parser(int32 );
#if __POWERPC__
#pragma export reset
#endif


/*

The documentation is really lousy, I know. It took me a long time to get
POLYLINES right. Here are some quick hints:

If a polyline has the 0x08 flag set, it is a 2D polyline (no polygons,
just lines). Just join the vertices with lines.

If a polyline has the 0x10 flag set, it is a polygon mesh. This means
you should create quads by connecting the vertices. You should use the
numbers found in groupcode 71 and 72 (countM and countN respectively).
But if the polyline has the groupcodes 73 and 74, you should use those
instead as countM and countN.

Then if flag 0x1 is set, this means that the polygon mesh is closed in
the M direction (countM), and if flag 0x20 is set, the polyline is closed
in the N direction (countN). Below is the source code that creates
the polygon mesh (creates quads). I use a callback mechanism to extract 
polygons, so the callback call will send the quad to the viewer. I hope
this code makes sense.

    m = countM;
    n = countN;

    int nexti, nextj;
    // check for closed polyline
    int endm = (this->flags & 1) ? m : m-1;
    int endn = (this->flags & 32) ? n : n-1;
    for (i = 0; i < endm; i++) {
      nexti = i+1;
      if (nexti == m) nexti = 0;
      for (int j = 0; j < endn; j++) {
	nextj = j+1;
	if (nextj == n) nextj = 0;
	idx = i*n + j;
	poly.coords[0] = this->coordVertices[idx]->coord;
	poly.tflags[0] = 0;
	
	idx = i*n + nextj;
	poly.coords[1] = this->coordVertices[idx]->coord;
	poly.tflags[1] = 0;
	
	idx = nexti*n + nextj;
	poly.coords[2] = this->coordVertices[idx]->coord;
	poly.tflags[2] = 0;

	idx = nexti*n + j;
	poly.coords[3] = this->coordVertices[idx]->coord;
	poly.tflags[3] = 0;
	callback(&poly, userdata);
      }
    }

If neither the 0x8 or the 0x10 flags are set, the polyline is a polyface
mesh. This means that some of the vertices will contain four indices to
the other vertices. These four indices will create a polygon.
If a vertex has its 0x80 flag set, and not the 0x40 flag, it will contain
four indices, and you should not use the coordinates from that vertex, but
instead use the indices found in groupcodes 71, 72, 73 and 74.


There are lots of other things you must code if you want full DXF support.
For instance the INSERT entity is quite complicated (Inserts blocks of
geometry found in the blocks section). Especially the extrusion direction
is very cryptic.
*/

#endif	/* _PARSER_DXF_H_ */

