//
//
//	LAP library File exceptions
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include "LAPfileException.h"
#include "LAPerrors.h"



LAPfileException::LAPfileException(int32 w, const char* l, const char* f)
: LAPexception(w, l)
{
	file = f;
}


LAPfileException::LAPfileException(LAPfileException& e)
: LAPexception(e.what, e.where)
{
	file = e.file;
}


LAPfileException::~LAPfileException()
{
}


void
LAPfileException::_Output(LAPtextBufferedOutput& out)
{
	LAPexception::_Output(out);
//	printf(", input %s", file);
	out << ", input " << file;
}


void
LAPfileException::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
//	printf("\n");
	out << eol << flush;
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPbadSeek::LAPbadSeek(const char* location, const char* f, off_t& a, off_t& l )
: LAPfileException(LAP_BAD_SEEK, location, f)
{
	asked = a;
	limit = l;
}


LAPbadSeek::LAPbadSeek(LAPbadSeek& e)
: LAPfileException(e.what, e.where, e.file)
{
	asked = e.asked;
	limit = e.limit;
}


LAPbadSeek::~LAPbadSeek()
{
}


void
LAPbadSeek::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
//	printf(": bad seek offset: 0x%Lx / 0x%Lx.\n", asked, limit);
	out << ": bad seek offset: 0x" << asked << " / 0x" << limit << '.' << eol << flush;
}
