//
//
//	LAP library parser exceptions
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include <ctype.h>
#include "LAPparserException.h"
#include "LAPerrors.h"



LAPparserException::LAPparserException(int32 w, const char* l)
: LAPexception(w, l)
{
}


LAPparserException::LAPparserException(LAPparserException& e)
: LAPexception(e.what, e.where)
{
}


LAPparserException::~LAPparserException()
{
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPmismatchToken::LAPmismatchToken(const char* location,
									LAPtoken et, const char* el,
									LAPtoken at, const char* al)
: LAPparserException(LAP_MISMATCH_TOKEN, location)
{
	expectedToken = et;
	expectedLexeme = el;
	actualToken = at;
	actualLexeme = al;
	type = LAP_NO_LITERAL;
}


LAPmismatchToken::LAPmismatchToken(const char* location,
									LAPtoken et, const char* el,
									LAPtoken at, const char* al, char v)
: LAPparserException(LAP_MISMATCH_TOKEN, location)
{
	expectedToken = et;
	expectedLexeme = el;
	actualToken = at;
	actualLexeme = al;
	type = LAP_CHARACTER_LITERAL;
	value.Char = v;
}


LAPmismatchToken::LAPmismatchToken(const char* location,
									LAPtoken et, const char* el,
									LAPtoken at, const char* al, int64& v)
: LAPparserException(LAP_MISMATCH_TOKEN, location)
{
	expectedToken = et;
	expectedLexeme = el;
	actualToken = at;
	actualLexeme = al;
	type = LAP_INTEGER_LITERAL;
	value.Int64 = v;
}


LAPmismatchToken::LAPmismatchToken(const char* location,
									LAPtoken et, const char* el,
									LAPtoken at, const char* al, double& v)
: LAPparserException(LAP_MISMATCH_TOKEN, location)
{
	expectedToken = et;
	expectedLexeme = el;
	actualToken = at;
	actualLexeme = al;
	type = LAP_FLOAT_LITERAL;
	value.Double = v;
}


LAPmismatchToken::LAPmismatchToken(const char* location,
									LAPtoken et, const char* el,
									LAPtoken at, const char* al, char* v)
: LAPparserException(LAP_MISMATCH_TOKEN, location)
{
	expectedToken = et;
	expectedLexeme = el;
	actualToken = at;
	actualLexeme = al;
	type = LAP_STRING_LITERAL;
	value.String = v;
}


LAPmismatchToken::LAPmismatchToken(LAPmismatchToken& e)
: LAPparserException(e.what, e.where)
{
	expectedToken = e.expectedToken;
	expectedLexeme = e.expectedLexeme;
	actualToken = e.actualToken;
	actualLexeme = e.actualLexeme;

	if (type == LAP_CHARACTER_LITERAL)
		value.Char = e.value.Char;
	else if (type == LAP_INTEGER_LITERAL)
		value.Int64 = e.value.Int64;
	else if (type == LAP_FLOAT_LITERAL)
		value.Double = e.value.Double;
	else if (type == LAP_STRING_LITERAL)
		value.String = e.value.String;
}


LAPmismatchToken::~LAPmismatchToken()
{
}


void
LAPmismatchToken::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": expected token " << expectedToken << ' ' << expectedLexeme
		<< ", got token " << actualToken << ' ' << actualLexeme;
//	printf(": expected token %d %s, got token %d %s ", expectedToken, expectedLexeme,
//			actualToken, actualLexeme);

	if (type == LAP_CHARACTER_LITERAL)
	{
		if (isprint(value.Char))
			out << " (character '" << value.Char << ").";
//			printf(" (character '%c').\n", value.Char);
		else
			out << " (ASCII character " << int16(value.Char) << ").";
//			printf(" (ASCII character %d).\n", int16(value.Char));
	}
	else if (type == LAP_INTEGER_LITERAL)
		out << " (integer " << value.Int64 << ").";
//		printf(" (integer %Ld).\n", value.Int64);
	else if (type == LAP_FLOAT_LITERAL)
		out << " (float " << value.Double << ").";
//		printf(" (float %g).\n", value.Double);
	else if (type == LAP_STRING_LITERAL)
//		printf(" (string '%s').\n", value.String);
		out << " (string '" << value.String << "').";
	out << eol << flush;
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPloadAborted::LAPloadAborted(const char* location)
: LAPparserException(LAP_LOAD_ABORTED, location)
{
}


LAPloadAborted::LAPloadAborted(LAPloadAborted& e)
: LAPparserException(e.what, e.where)
{
}


LAPloadAborted::~LAPloadAborted()
{
}


void
LAPloadAborted::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": load aborted" << eol << flush;
//	printf(": load aborted\n");
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPbadScope::LAPbadScope(const char* location)
: LAPparserException(LAP_BAD_SCOPE, location)
{
}


LAPbadScope::LAPbadScope(LAPbadScope& e)
: LAPparserException(e.what, e.where)
{
}


LAPbadScope::~LAPbadScope()
{
}


void
LAPbadScope::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": bad scope" << eol << flush;
//	printf(": bad scope\n");
}


//-------------------------------------------------------------
//
//-------------------------------------------------------------

LAPmismatchLength::LAPmismatchLength(const char* location, off_t exp, off_t act)
: LAPparserException(LAP_MISMATCH_LENGTH, location)
{
	expected = exp;
	actual = act;
}


LAPmismatchLength::LAPmismatchLength(LAPmismatchLength& e)
: LAPparserException(e.what, e.where)
{
	expected = e.expected;
	actual = e.actual;
}


LAPmismatchLength::~LAPmismatchLength()
{
}


void
LAPmismatchLength::Output(LAPtextBufferedOutput& out)
{
	_Output(out);
	out << ": mismatch length, expected " << expected
		<< " got " << actual << eol << flush;
}
