//
//
//	LAP statically-allocated buffer class
//
//											(C) JoOl 1998


#ifndef _LAP_STATIC_BUFFER_H_
#define _LAP_STATIC_BUFFER_H_


#include "LAPimpexp.h"

#include "LAPcommon.h"

#include <File.h>
#include <Path.h>

#define LAP_BUFFER_BLOCK_LEN	128
#define LAP_BUFFER_WORK_LEN		32


// buffer inputs
enum
{
	LAP_BUFFER_NO_INPUT,
	LAP_BUFFER_FILE_INPUT,
	LAP_BUFFER_MEMORY_INPUT
};

// buffer outputs
enum
{
	LAP_BUFFER_NO_OUTPUT			= 0x00,
	LAP_BUFFER_SCREEN_OUTPUT		= 0x01,
	LAP_BUFFER_FILE_OUTPUT			= 0x02,
	LAP_BUFFER_BHANDLER_OUTPUT		= 0x04
};

// buffer policies
enum
{
	LAP_BUFFER_GROW_ON_OVERFLOW,
	LAP_BUFFER_ERROR_ON_OVERFLOW,
	LAP_BUFFER_OUTPUT_ON_OVERFLOW
};



class		LAPbadAlloc;
class		LAPbadBufferWrite;
class		LAPbadBufferRead;



class						LAPbuffer
{
	void					SetSize(int32 );
	void					Alloc(int32 ); // throw (LAPbadAlloc);

protected:


#pragma export on

	status_t				status;

	// buffer config
	int32					blockSize;		// alloc block size
	char*					buffer;
	int32					alloc;			// current buffer alloc

	int32					writePtr;		// used by Append*
	void					_badWrite(char* , int32 ); // throw (LAPbadBufferWrite);
	virtual void			badWrite(char* , int32 );

	bool					eofFlag;
	int32					readPtr;		// used by Read*
	void					_badRead(char* , int32 ); // throw (LAPbadBufferRead);
	virtual void			badRead(char* , int32 );


	LAPendianness			hardwareEndianness;

public:
							LAPbuffer(int32 = LAP_BUFFER_BLOCK_LEN);
	virtual					~LAPbuffer();

	status_t				GetStatus() const;
	bool					CheckStatus() const;

	bool					IsFull() const;
	bool					canRead() const;
	bool					canWrite() const;
	void					Reset();

	char*					Detach(int32& ); // throw (LAPbadAlloc);
	const char*				GetBuffer(int32& ) const;
	int32					GetLength() const;
	int32					GetAlloc() const;

	// output related methods
	void					Append(char* , int32 );
	void					AppendWhatFits(char*& , int32& );

	// input related methods
	void					Read(char* , int32 );
	void					Read(char& );
	void					ReadWhatsLeft(char*& , int32& );


#pragma export reset
};


#endif	/* _LAP_STATIC_BUFFER_H_ */
