//
//
//	LAP Lexer class
//
//										(C) JoOl 1998


#ifndef _LAP_LEXER_H_
#define _LAP_LEXER_H_


#include "LAPbufferedInput.h"
#include "LAPdisplay.h"
#include "LAPtoken.h"
#include "LAPtracer.h"
#include "LAPlexerException.h"
#include "LAPmemoryException.h"
#include "LAPappliInterface.h"


#define LAP_LEXER_BUFFLEN		1024
#define LAP_LEXER_LEXMLEN		256


class						LAPlexer
{
protected:
	LAPbufferedInput*		_input;
	entry_ref				inputRef;
	BPath					inputPath;
	virtual status_t		_SetInput(entry_ref ) = 0;

	LAPdisplay*				display;
	LAPtracer*				errorOutput;
	LAPtextBufferedOutput*	traceOutput;

	LAPappliInterface*		appliInterface;


//#if __POWERPC__
#pragma export on
//#endif
							LAPlexer(LAPbufferedInput* ); // throw (LAPbadInit);
public:
	virtual					~LAPlexer();

	void					SetAppliInterface(LAPappliInterface* );
	LAPappliInterface*		GetAppliInterface() const;

	bool					Eof() const;
	off_t					GetPosition() const;
	off_t					GetInputPosition() const;
	entry_ref				GetInputRef() const;
	const char*				GetInputName() const;
	const char*				GetInputPath() const;

	void					SetDisplay(LAPdisplay* ); // throw (LAPbadInit);
	void					SetErrorOutput(LAPtracer* ); // throw (LAPbadInit);
	void					SetTraceOutput(LAPtextBufferedOutput* );

	status_t				SetInput(entry_ref );
	void					Terminate();

//#if __POWERPC__
#pragma export reset
//#endif
};


#endif	/* _LAP_LEXER_H_ */

