//
//
//	LAP token set class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include <new.h>
#include "LAPtokenSet.h"
#include "LAPmemoryException.h"


void
LAPtokenSet::Alloc(int32 n)
{
	try
	{
		nbTokens = 0;
		tokens = new LAPtoken[n];
		allocTokens = n;
	}
	catch (bad_alloc )
	{
		throw LAPbadAlloc("LAPtokenSet::Alloc", "tokens", n*sizeof(int32));
	}
}


LAPtokenSet::LAPtokenSet()
{
	nbTokens = allocTokens = 0;
	tokens = NULL;
}


LAPtokenSet::LAPtokenSet(int32 n, LAPtoken* t)
{
	Alloc(n);
	for (int32 i = 0; i < n; i++)
		tokens[i] = t[i];
}


LAPtokenSet::LAPtokenSet(LAPtoken a)
{
	Alloc(1);
	tokens[0] = a;
	nbTokens = 1;
}


LAPtokenSet::LAPtokenSet(LAPtoken a, LAPtoken b)
{
	Alloc(2);
	tokens[0] = a;
	tokens[1] = b;
	nbTokens = 2;
}


LAPtokenSet::LAPtokenSet(LAPtoken a, LAPtoken b, LAPtoken c)
{
	Alloc(3);
	tokens[0] = a;
	tokens[1] = b;
	tokens[2] = c;
	nbTokens = 3;
}


LAPtokenSet::LAPtokenSet(LAPtoken a, LAPtoken b, LAPtoken c, LAPtoken d)
{
	Alloc(4);
	tokens[0] = a;
	tokens[1] = b;
	tokens[2] = c;
	tokens[3] = d;
	nbTokens = 4;
}


LAPtokenSet::LAPtokenSet(LAPtoken a, LAPtoken b, LAPtoken c, LAPtoken d, LAPtoken e)
{
	Alloc(5);
	tokens[0] = a;
	tokens[1] = b;
	tokens[2] = c;
	tokens[3] = d;
	tokens[4] = e;
	nbTokens = 5;
}


LAPtokenSet::~LAPtokenSet()
{
	delete[] tokens;
}


int32
LAPtokenSet::GetNbTokens()
{
	return nbTokens;
}


LAPtoken
LAPtokenSet::GetToken(int32 i)
{
	if (i < 0 || i >= nbTokens)
		return 0;
	return tokens[i];
}


bool
LAPtokenSet::Add(LAPtoken a)
{
	if (nbTokens >= allocTokens)
		return false;
	tokens[nbTokens++] = a;
	return true;
}


bool
LAPtokenSet::Contains(LAPtoken t) const
{
	for (int32 i = 0; i < nbTokens; i++)
		if (tokens[i] == t)
			return true;
	return false;
}


LAPtokenSet
LAPtokenSet::operator+(LAPtokenSet& b)
{
	LAPtokenSet		out;
	out.Alloc(nbTokens + b.GetNbTokens());
	for (int32 i = 0; i < nbTokens; i++)
		out.Add(tokens[i]);
	for (int32 i = 0; i < b.GetNbTokens(); i++)
		out.Add(b.GetToken(i));
	return out;
}
