//
//
//	LAP binary parser class
//
//										(C) JoOl 1998

#include "LAPimpexp.h"

#include "LAPbinParser.h"
#include "LAPerrors.h"
#include "LAPfileException.h"



LAPbinParser::LAPbinParser()
{
	lexer = NULL;
}


LAPbinParser::~LAPbinParser()
{
	// lexer destroyed in LAPparser::~LAPparser
}


void
LAPbinParser::SetLexer(LAPbinLexer* l)
{
	LAPparser::SetLexer(l);
	lexer = l;
}


status_t
LAPbinParser::SetInput(entry_ref ref, uint8 flags)
{
	if (!lexer)
		return LAP_BAD_INIT;
	if (!display)
		return LAP_BAD_INIT;
	if (!errorOutput)
		return LAP_BAD_INIT;

	abortRequested = false;

	entry_ref			tref = ref;
	BEntry				e(&tref, true);
	status_t			s = lexer->SetInput(tref);
	if (s != LAP_NO_ERROR)
		return s;

	if (Identify() != LAP_NO_ERROR)
		return LAP_BAD_INPUT_TYPE;

	s = lexer->SetInput(tref);
	if (s != LAP_NO_ERROR)
		return s;
	if ((flags & LAP_TRACE) && (traceOutput))
		SetTraceFile(ref, B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
	if (flags & LAP_ERRORS_TRACE)
		SetMessagesTraceFile(ref, B_WRITE_ONLY | B_CREATE_FILE | B_ERASE_FILE);
	return LAP_NO_ERROR;
}


void
LAPbinParser::ReadInt8(int8& Out)
{
	try
	{
		lexer->ReadInt8(Out);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadInt8\n");
			throw LAPloadAborted("LAPbinParser::ReadInt8");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadInt8";
		throw;
	}
}


void
LAPbinParser::ReadInt8(uint8& Out)
{
	ReadInt8((int8& )Out);
}


void
LAPbinParser::ReadInt16(int16& Out)
{
	try
	{
		lexer->ReadInt16(Out);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadInt16\n");
			throw LAPloadAborted("LAPbinParser::ReadInt16");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadInt16";
		e.asked = sizeof(Out);
		throw;
	}
}


void
LAPbinParser::ReadInt16(uint16& Out)
{
	ReadInt16((int16& )Out);
}


void
LAPbinParser::ReadInt32(int32& Out)
{
	try
	{
		lexer->ReadInt32(Out);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadInt32\n");
			throw LAPloadAborted("LAPbinParser::ReadInt32");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadInt32";
		e.asked = sizeof(Out);
		throw;
	}
}


void
LAPbinParser::ReadInt32(uint32& Out)
{
	ReadInt32((int32& )Out);
}


void
LAPbinParser::ReadInt64(int64& Out)
{
	try
	{
		lexer->ReadInt64(Out);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadInt64\n");
			throw LAPloadAborted("LAPbinParser::ReadInt64");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadInt64";
		e.asked = sizeof(Out);
		throw;
	}
}


void
LAPbinParser::ReadInt64(uint64& Out)
{
	ReadInt64((int64& )Out);
}


void
LAPbinParser::ReadFloat(float& Out)
{
	try
	{
		lexer->ReadFloat(Out);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadFloat\n");
			throw LAPloadAborted("LAPbinParser::ReadFloat");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadFloat";
		e.asked = sizeof(Out);
		throw;
	}
}


void
LAPbinParser::ReadDouble(double& Out)
{
	try
	{
		lexer->ReadDouble(Out);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadDouble\n");
			throw LAPloadAborted("LAPbinParser::ReadDouble");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadDouble";
		e.asked = sizeof(Out);
		throw;
	}
}


void
LAPbinParser::ReadBytes(char* Out, int32 n)
{
	try
	{
		lexer->ReadBytes(Out, n);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadBytes\n");
			throw LAPloadAborted("LAPbinParser::ReadBytes");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadBytes";
		e.asked = n;
		throw;
	}
}


void
LAPbinParser::ReadString(char* Out, int32 n)
{
	try
	{
		lexer->ReadString(Out, n);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::ReadString\n");
			throw LAPloadAborted("LAPbinParser::ReadString");
		}
	}
	catch (LAPbadBufferRead& e)
	{
		e.where = "LAPbinParser::ReadString";
		e.asked = n;
		throw;
	}
}


void
LAPbinParser::SkipBytes(int32 n)
{
	try
	{
		lexer->SkipBytes(n);
		if ((abortRequested) && (Locker.CountLocks() == 0))
		{
//printf("THROW LAPbinParser::SkipBytes\n");
			throw LAPloadAborted("LAPbinParser::SkipBytes");
		}
	}
	catch (LAPbadSeek& e)
	{
		e.where = "LAPbufferedInput::SkipBytes";
		throw ;
	}
}
