//
//
//	LAP display stack class
//
//										(C) JoOl 1998


#include "LAPimpexp.h"

#include <new.h>
#include "LAPdisplay.h"
#include "LAPerrors.h"


LAPdisplay::LAPdisplay()
{
}


LAPdisplay::~LAPdisplay()
{
	for (int32 i = 0; i < stack.CountItems(); i++)
		delete (LAPsymbolTable* )stack.ItemAt(i);
	stack.MakeEmpty();
}


bool
LAPdisplay::IsEmpty() const
{
	return stack.CountItems() == 0;
}


int32
LAPdisplay::GetCurrentLevel() const
{
	return stack.CountItems();
}


LAPsymbolTable*
LAPdisplay::GetScope(int32 i) const
{
	LAPsymbolTable*		st = (LAPsymbolTable* )stack.ItemAt(i);
	if (!st)
		throw LAPbadScope("LAPdisplay::GetScope");
	return st;
}


LAPsymbolTable*
LAPdisplay::GetCurrentScope() const
{
	LAPsymbolTable*		st = (LAPsymbolTable* )stack.ItemAt(stack.CountItems()-1);
	if (!st)
		throw LAPbadScope("LAPdisplay::GetCurrentScope");
	return st;
}


LAPsymbolTable*
LAPdisplay::GetGlobalScope() const
{
	LAPsymbolTable*		st = (LAPsymbolTable* )stack.ItemAt(0);
	if (!st)
		throw LAPbadScope("LAPdisplay::GetGlobalScope");
	return st;
}


LAPsymbolTable*
LAPdisplay::EnterScope()
{
	try
	{
		LAPsymbolTable*		st = new LAPsymbolTable(NULL);
		stack.AddItem(st);
		return st;
	}
	catch (bad_alloc )
	{
		throw LAPbadAlloc("LAPdisplay::EnterScope", "st", sizeof(LAPsymbolTable));
		return NULL;	// to avoid a compiler warning only
	}
}


LAPsymbolTable*
LAPdisplay::EnterLocalScope()
{
	try
	{
		LAPsymbolTable*		parent = (IsEmpty()) ? NULL : GetCurrentScope();
		LAPsymbolTable*		st = new LAPsymbolTable(parent);
		stack.AddItem(st);
		return st;
	}
	catch (bad_alloc )
	{
		throw LAPbadAlloc("LAPdisplay::EnterLocalScope", "st", sizeof(LAPsymbolTable));
		return NULL;	// to avoid a compiler warning only
	}
}


LAPsymbolTable*
LAPdisplay::ExitScope()
{
	if (stack.CountItems() < 1)
		throw LAPbadScope("LAPdisplay::ExitScope");

	return (LAPsymbolTable* )stack.RemoveItem(stack.CountItems() - 1);
}


LAPsymbol*
LAPdisplay::Search(char* n) const
{
	LAPsymbolTable*		t = GetCurrentScope();
	if (!t)
		throw LAPbadScope("LAPdisplay::Search");
	return t->Search(n);
}


LAPsymbol*
LAPdisplay::SearchLocal(char* n) const
{
	LAPsymbolTable*		t = GetCurrentScope();
	if (!t)
		throw LAPbadScope("LAPdisplay::SearchLocal");
	return t->SearchLocal(n);
}


// Insert in the current scope
status_t
LAPdisplay::Insert(LAPsymbol* s)
{
	LAPsymbolTable*		t = GetCurrentScope();
	if (!t)
		throw LAPbadScope("LAPdisplay::Insert");
	return t->Insert(s);
}

