//
//
//	Pierrot array
//
//											(C) JoOl 1998


#ifndef _PIERROT_ARRAY_H_
#define _PIERROT_ARRAY_H_


#include <SupportDefs.h>
#include <malloc.h>
#include <string.h>
#include <stdio.h>


template <class Item>
class					PierrotArray
{
protected:
	typedef int			pCmpFunc(Item& , void* );

	Item*				items;
	int32				nbItems;
	int32				blockSize;
	int32				nbSlots;

	void				Grow(int32 newSize)
	{
		Item*			newItems = (Item* )malloc(sizeof(Item) * newSize);
		memcpy(newItems, items, sizeof(Item) * nbItems);
		free(items);
		items = newItems;
		nbSlots = newSize;
	}

public:

	PierrotArray()
	{
		items = NULL;
		nbItems = nbSlots = blockSize = 0;
	};

	PierrotArray(int32 isize, int32 bsize)
	{
		items = NULL;
		SetAlloc(isize, bsize);
	};

	~PierrotArray()
	{
		DelAlloc();
	};

	void				GrowForItems(int32 n)
	{
		if (nbItems+n > nbSlots)
			Grow(nbItems + n);
	};


	void				SetAlloc(int32 isize, int32 bsize)
	{
		DelAlloc();
		items = (Item* )malloc(sizeof(Item) * isize);
		nbItems = 0;
		nbSlots = isize;
		blockSize = bsize;
	};

	void				DelAlloc()
	{
		if (items)
			free(items);
		nbSlots = blockSize = nbItems = 0;
	};

	bool				IsAllocated() const
	{ return items != NULL; };

	void				MakeEmpty()
	{ nbItems = 0; };

	int32				CountItems() const
	{ return nbItems; };
	Item*				Items() const
	{ return items; };
	Item&				operator[] (int32 index)
	{ return items[index]; };

	void				AddItem(Item& item)
	{
		if (nbItems >= nbSlots)
			Grow(nbSlots + blockSize);
		if (nbSlots <= nbItems)
			printf("**** PierrotArray::AddItem: can't accomodate new item\n\
					nbItems=%d, nbSlots=%d, blockSize=%d\n",
					nbItems, nbSlots, blockSize);
		memcpy(&items[nbItems], &item, sizeof(Item));
		nbItems++;
	};

	int32				Search(pCmpFunc cf, void* val)
	{
		for (int32 i = 0; i < nbItems; i++)
		{
			if (!cf(items[i], val))
				return i;
		}
		return -1;
	};
};


#endif /* _PIERROT_ARRAY_H_ */
