//
//
//	Pierrot 3d geometry
//
//										(C) JoOl 1998


#ifndef _PIERROT_3D_GEOMETRY_H_
#define _PIERROT_3D_GEOMETRY_H_


#define PIERROT_EPSILON 0.00001


class pVector3;
class pLine;
class pPlane;
class pMatrix3;



//--------------------------------------------------------
// 3d position
//--------------------------------------------------------

class					pPoint3
{
public:
	float				x, y, z;

#pragma export on
						pPoint3();
						pPoint3(float, float, float);
						pPoint3(pPoint3& );
						~pPoint3();

	void				Set(float, float, float);
	void				Clear();

	bool				Eq(pPoint3& , float = PIERROT_EPSILON);
	pPoint3				Project(pLine& );
	pPoint3				Project(pPlane& );
	pPoint3				ProjectXoY();
	pPoint3				ProjectYoZ();
	pPoint3				ProjectXoZ();
	pPoint3				Mirror(pLine& );
	pPoint3				Mirror(pPlane& );
	pPoint3				MirrorXoY();
	pPoint3				MirrorYoZ();
	pPoint3				MirrorXoZ();

	pPoint3				operator*(float );
	pPoint3				operator/(float );
	float				operator*(pPoint3& );
	float				operator*(pVector3& );
	pPoint3 			operator*(pMatrix3& );
	pPoint3&			operator*=(float );
	pPoint3&			operator*=(pMatrix3& );
	pPoint3&			operator/=(float );

	pPoint3				operator+(pPoint3& );
	pPoint3				operator+(pVector3& );
	pPoint3&			operator+=(pPoint3& );
	pPoint3&			operator+=(pVector3& );
	pPoint3				operator-(pPoint3& );
	pPoint3				operator-(pVector3& );
	pPoint3&			operator-=(pPoint3& );
	pPoint3&			operator-=(pVector3& );

	pPoint3&			operator=(pPoint3& );
	pPoint3&			operator=(pVector3& );
	int					operator==(pPoint3& );
	int					operator!=(pPoint3& );

#pragma export reset
};



//--------------------------------------------------------
// 3d vector
//--------------------------------------------------------

class					pVector3
{
public:
	float				x, y, z;

#pragma export on
						pVector3();
						pVector3(float, float, float);
						pVector3(pPoint3& , pPoint3& );
						pVector3(pVector3& );
						~pVector3();

	void				Set(float, float, float);
	void				Set(pPoint3& , pPoint3& );
	void				Clear();

	bool				Eq(pVector3& , float = PIERROT_EPSILON);
	pVector3			ProjectXoY();
	pVector3			ProjectYoZ();
	pVector3			ProjectXoZ();
	pVector3			MirrorXoY();
	pVector3			MirrorYoZ();
	pVector3			MirrorXoZ();

	bool				Colinear(pVector3& , float = PIERROT_EPSILON);
	bool				Orthogonal(pVector3& , float = PIERROT_EPSILON);

	float				Length2() const;
	float				Length() const;
	void				Norm();

	pVector3			operator*(float );
	pVector3			operator/(float );
	float				operator*(pPoint3& );
	float				operator*(pVector3& );
	pVector3 			operator*(pMatrix3& );
	pVector3 			operator^(pVector3& );
	pVector3&			operator*=(float );
	pVector3&			operator*=(pMatrix3& );
	pVector3&			operator/=(float );

	pVector3			operator+(pPoint3& );
	pVector3			operator+(pVector3& );
	pVector3&			operator+=(pPoint3& );
	pVector3&			operator+=(pVector3& );
	pVector3			operator-(pPoint3& );
	pVector3			operator-(pVector3& );
	pVector3&			operator-=(pPoint3& );
	pVector3&			operator-=(pVector3& );

	pVector3&			operator=(pPoint3& );
	pVector3&			operator=(pVector3& );
	int					operator==(pVector3& );
	int					operator!=(pVector3& );

#pragma export reset
};



//--------------------------------------------------------
// 3d line
//--------------------------------------------------------

class					pLine
{
public:

#pragma export on

	pPoint3				pt;
	pVector3			dir;

						pLine();
						pLine(pPoint3& , pPoint3& );
						pLine(pPoint3& , pVector3& );
						pLine(pLine& );
						~pLine();

	void				Set(pPoint3& , pPoint3& );
	void				Set(pPoint3& , pVector3& );
	pPoint3				Pt2();

	bool				Eq(pLine& , float = PIERROT_EPSILON);
	bool				Parallel(pLine& , float = PIERROT_EPSILON);
	bool				Parallel(pPlane& , float = PIERROT_EPSILON);
	bool				Orthogonal(pLine& , float = PIERROT_EPSILON);
	bool				Orthogonal(pPlane& , float = PIERROT_EPSILON);
	bool				Contains(pPoint3& , float = PIERROT_EPSILON);
	bool				Intersects(pPlane& , pPoint3& , float = PIERROT_EPSILON);
	pLine				Project(pPlane& );
	pLine				ProjectXoY();
	pLine				ProjectYoZ();
	pLine				ProjectXoZ();
	pLine				Mirror(pPlane& );
	pLine				MirrorXoY();
	pLine				MirrorYoZ();
	pLine				MirrorXoZ();

	pLine&				operator=(pLine& );
	int					operator==(pLine& );
	int					operator!=(pLine& );

#pragma export reset
};


//--------------------------------------------------------
// 3d plane
//--------------------------------------------------------

class					pPlane
{
public:

#pragma export on

	pPoint3				pt;
	pVector3			normal;

						pPlane();
						pPlane(pPoint3& , pVector3& );
						pPlane(pPoint3& , pPoint3& , pPoint3& );
						pPlane(pPoint3& , pVector3& , pVector3& );
						pPlane(pPlane& );
						~pPlane();

	void				Set(pPoint3& , pVector3& );
	void				Set(pPoint3& , pPoint3& , pPoint3& );
	void				Set(pPoint3& , pVector3& , pVector3& );

	bool				Eq(pPlane& , float = PIERROT_EPSILON);
	bool				Parallel(pLine& , float = PIERROT_EPSILON);
	bool				Parallel(pPlane& , float = PIERROT_EPSILON);
	bool				Orthogonal(pLine& , float = PIERROT_EPSILON);
	bool				Orthogonal(pPlane& , float = PIERROT_EPSILON);
	bool				Contains(pPoint3& , float = PIERROT_EPSILON);
	bool				Contains(pLine& , float = PIERROT_EPSILON);

	pPlane				ProjectXoY();
	pPlane				ProjectYoZ();
	pPlane				ProjectXoZ();
	pPlane				MirrorXoY();
	pPlane				MirrorYoZ();
	pPlane				MirrorXoZ();

	pPlane&				operator=(pPlane& );
	int					operator==(pPlane& );
	int					operator!=(pPlane& );

#pragma export reset

};



//--------------------------------------------------------
// texture point
//--------------------------------------------------------

class					pTexPoint
{
public:
	float				s, t, r, q;

#pragma export on

						pTexPoint();
						pTexPoint(float , float , float , float );
						pTexPoint(pTexPoint& p);
						~pTexPoint();

	void				Set(float , float , float , float );
	void				Set(pTexPoint& );
	void				Clear();

	pTexPoint&			operator=(pTexPoint& );
	int					operator!=(pTexPoint& );
	int					operator==(pTexPoint& );

#pragma export reset
};


#endif /* _PIERROT_3D_GEOMETRY_H_ */
