//
//
//	Pierrot 4d geometry
//
//										(C) JoOl 1998


#ifndef _PIERROT_GEOMETRY_4_H_
#define _PIERROT_GEOMETRY_4_H_


#include "PierrotGeometry.h"


class pVector4;
class pMatrix4;



//--------------------------------------------------------
// 4d position
//--------------------------------------------------------

class					pPoint4
{
public:
	float				x, y, z, w;

#pragma export on
						pPoint4();
						pPoint4(float, float, float, float);
						pPoint4(pPoint4& );
						~pPoint4();

	void				Set(float, float, float, float);
	void				Clear();
	pPoint3				Perspective();

	pPoint4				operator*(float );
	pPoint4				operator/(float );
	float				operator*(pPoint4& );
	float				operator*(pVector4& );
	pPoint4 			operator*(pMatrix4& );
	pPoint4&			operator*=(float );
	pPoint4&			operator*=(pMatrix4& );
	pPoint4&			operator/=(float );

	pPoint4				operator+(pPoint4& );
	pPoint4				operator+(pVector4& );
	pPoint4&			operator+=(pPoint4& );
	pPoint4&			operator+=(pVector4& );
	pPoint4				operator-(pPoint4& );
	pPoint4				operator-(pVector4& );
	pPoint4&			operator-=(pPoint4& );
	pPoint4&			operator-=(pVector4& );

	pPoint4&			operator=(pPoint4& );
	pPoint4&			operator=(pVector4& );
	int					operator==(pPoint4& );
	int					operator!=(pPoint4& );

#pragma export reset
};



//--------------------------------------------------------
// 4d vector
//--------------------------------------------------------

class					pVector4
{
public:
	float				x, y, z, w;

#pragma export on
						pVector4();
						pVector4(float, float, float, float);
						pVector4(pPoint4& , pPoint4& );
						pVector4(pVector4& );
						~pVector4();

	void				Set(float, float, float, float);
	void				Set(pPoint4& , pPoint4& );
	void				Clear();
	pVector3			Perspective();

	float				Length2() const;
	float				Length() const;
	void				Norm();

	pVector4			operator*(float );
	pVector4			operator/(float );
	float				operator*(pPoint4& );
	float				operator*(pVector4& );
	pVector4 			operator*(pMatrix4& );
	pVector4&			operator*=(float );
	pVector4&			operator*=(pMatrix4& );
	pVector4&			operator/=(float );

	pVector4			operator+(pPoint4& );
	pVector4			operator+(pVector4& );
	pVector4&			operator+=(pPoint4& );
	pVector4&			operator+=(pVector4& );
	pVector4			operator-(pPoint4& );
	pVector4			operator-(pVector4& );
	pVector4&			operator-=(pPoint4& );
	pVector4&			operator-=(pVector4& );

	pVector4&			operator=(pPoint4& );
	pVector4&			operator=(pVector4& );
	int					operator==(pVector4& );
	int					operator!=(pVector4& );

#pragma export reset
};


#endif /* _PIERROT_GEOMETRY_4_H_ */
