//
//
//	Pierrot points array
//
//											(C) JoOl 1998


#ifndef _PIERROT_POINTS_ARRAY_H_
#define _PIERROT_POINTS_ARRAY_H_

#include "PierrotArray.h"
#include "PierrotGeometry.h"


//-----------------------------------------------
// points arrays
//-----------------------------------------------

class						pPointsArray: public PierrotArray<pPoint3 >
{
	static int				pPointCmpFunc(pPoint3& pt1, void* pt2)
	{ return (pt1 == (*(pPoint3* )pt2)) ? 0 : 1; };

public:

	pPointsArray()
	{};

	pPointsArray(int32 is, int32 bs)
	: PierrotArray<pPoint3 >(is, bs)
	{};

	int32					Search(pPoint3& p)
	{
		return PierrotArray::Search(pPointCmpFunc, &p);
	};
};


//-----------------------------------------------
// vectors arrays
//-----------------------------------------------

class						pVectorsArray: public PierrotArray<pVector3 >
{
	static int				pVectorCmpFunc(pVector3& pt1, void* pt2)
	{ return (pt1 == (*(pVector3* )pt2)) ? 0 : 1; };

public:

	pVectorsArray()
	{};

	pVectorsArray(int32 is, int32 bs)
	: PierrotArray<pVector3 >(is, bs)
	{};

	int32					Search(pVector3& p)
	{
		return PierrotArray::Search(pVectorCmpFunc, &p);
	};
};


//-----------------------------------------------
// TexPoints arrays
//-----------------------------------------------

class						pTexPointsArray: public PierrotArray<pTexPoint >
{
	static int				pTexPointCmpFunc(pTexPoint& pt1, void* pt2)
	{ return (pt1 == (*(pTexPoint* )pt2)) ? 0 : 1; };

public:

	pTexPointsArray()
	{};

	pTexPointsArray(int32 is, int32 bs)
	: PierrotArray<pTexPoint >(is, bs)
	{};

	int32					Search(pTexPoint& p)
	{
		return PierrotArray::Search(pTexPointCmpFunc, &p);
	};
};


#endif /* _PIERROT_POINTS_ARRAY_H_ */
