//
//
//	Pierrot 3d scene
//
//										(C) JoOl 1998


#ifndef _PIERROT_3D_SCENE_H_
#define _PIERROT_3D_SCENE_H_



#include "PierrotImpExp.h"

#include <Locker.h>
#include "PierrotLight.h"
#include "PierrotObject.h"
#include "PierrotViewSys.h"

#include "PierrotLightsArray.h"
#include "PierrotMaterialsArray.h"
#include "PierrotObjectsArray.h"

#include "LAPappliInterface.h"


enum
{
	// lights GArray default values
	DEFAULT_LIGHTS_ALLOC = 8,
	DEFAULT_LIGHTS_BLOCK = 4,

	// materials GArray default values
	DEFAULT_MATERIALS_ALLOC = 16,
	DEFAULT_MATERIALS_BLOCK = 8,

	// materials GArray default values
	DEFAULT_OBJECTS_ALLOC = 16,
	DEFAULT_OBJECTS_BLOCK = 16
};


class							pScene
{
	BLocker						locker;
	pSphere						originalBounds;


public:
	char*						name;
	pSpectra					background;

	pBox						bounds;
	pSphere						sbounds;
	pSpectra					ambient;

	pViewSys					viewsys;

	pLightsArray				lights;
	pMaterialsArray				materials;
	pObjectsArray				objects;

#pragma export on

								pScene(char* ,	int32 = DEFAULT_LIGHTS_ALLOC,
												int32 = DEFAULT_LIGHTS_BLOCK,
												int32 = DEFAULT_MATERIALS_ALLOC,
												int32 = DEFAULT_MATERIALS_BLOCK,
												int32 = DEFAULT_OBJECTS_ALLOC,
												int32 = DEFAULT_OBJECTS_BLOCK);
								~pScene();

	bool						Lock();
	void						Unlock();

	bool						IsNormalized();
	void						Unnormalize();

	void						SetMaterialCounts();
	void						SetNormals(LAPappliInterface* , float , float);
	void						NormalizeTo(pSphere& , LAPappliInterface* , float , float);
	void						MoveTo(pPoint3& , LAPappliInterface* , float , float );
	void						ScaleTo(float , LAPappliInterface* , float , float );
	void						SetBounds(LAPappliInterface* , float , float);
	void						Preprocess(pSphere* , LAPappliInterface* , float , float );
	void						ReverseFaces();
	bool						HasTransparentFaces();

	void						SetDefaultView();
	void						Merge(pScene* );//, LAPappliInterface* , float , float );

#pragma export reset
};


#endif /* _PIERROT_3D_SCENE_H_ */
