//
//
//	Pierrot viewing system
//
//										(C) JoOl 1998


#ifndef _PIERROT_VIEWING_SYSTEM_H_
#define _PIERROT_VIEWING_SYSTEM_H_


#include <SupportDefs.h>
#include "PierrotGeometry.h"
#include "PierrotMatrix.h"



class					pViewSys
{
public:
	float				matrix[16];

	float				distance;
	pPoint3				target;
	pPoint3				origin;
	pVector3			u, v, n;


#pragma export on
						pViewSys();
						~pViewSys();

	void				SetDefault();
	void				SetTo(float , pPoint3& );
	void				SetTo(pPoint3& , pPoint3& , float );
	void				Rotate(pVector3& , float );
	void				RotateU(float );
	void				RotateV(float );
	void				RotateN(float );
	void				Zoom(float );

	void				BuildMatrix();
	void				BuildMatrix2();
	float*				GetMatrix();

	int32				operator==(pViewSys& );
	int32				operator!=(pViewSys& );

#pragma export reset
};


#endif /* _PIERROT_VIEWING_SYSTEM_H_ */
