//
//
//	Pierrot 3d volume
//
//										(C) JoOl 1998


#ifndef _PIERROT_3D_VOLUME_H_
#define _PIERROT_3D_VOLUME_H_

#include "PierrotGeometry.h"
#include "PierrotPointsArray.h"



//--------------------------------------------------------
// 3d box
//--------------------------------------------------------

class					pBox
{
public:
	pPoint3				minPt, maxPt;

#pragma export on
						pBox();
						pBox(pPoint3& , pPoint3& );
						pBox(pBox& );
						~pBox();

	void				Set(pPoint3& , pPoint3& );
	void				SetMin(pPoint3& );
	void				SetMax(pPoint3& );
	pPoint3				Center();

	bool				Eq(pBox& , float = PIERROT_EPSILON);

	bool				Contains(pPoint3& ) const;
	bool				Contains(pBox& ) const;
	bool				Excludes(pPoint3& ) const;
	bool				Excludes(pBox& ) const;

	pBox				operator | (pPoint3& );
	pBox				operator | (pBox& );
	pBox&				operator |= (pPoint3& );
	pBox&				operator |= (pBox& );

	pBox&				operator = (pBox& );
	int					operator == (pBox& );
	int					operator != (pBox& );

#pragma export reset
};


//--------------------------------------------------------
// spin volume
//--------------------------------------------------------

class						pSpinVolume
{
public:
	virtual pPointsArray*	GenerateSpinDesc(int32 ) = 0;
	virtual void			GetPosition(pPoint3& , pVector3& ) = 0;
};


//--------------------------------------------------------
// 3d sphere
//--------------------------------------------------------

class					pSphere: public pSpinVolume
{
public:
	pPoint3				center;
	float				radius;

#pragma export on
						pSphere();
						pSphere(pPoint3& , float );
						pSphere(pSphere& );
						~pSphere();

	void				Set(pPoint3& , float );
	bool				Eq(pSphere& , float = PIERROT_EPSILON);

	bool				Contains(pPoint3& );
	bool				Contains(pSphere& );
	bool				Excludes(pPoint3& );
	bool				Excludes(pSphere& );

	pSphere				operator | (pPoint3& );
	pSphere&			operator |= (pPoint3& );
	pSphere				operator | (pSphere& );
	pSphere&			operator |= (pSphere& );

	pSphere&			operator = (pSphere& );
	int					operator == (pSphere& );
	int					operator != (pSphere& );


	virtual pPointsArray*	GenerateSpinDesc(int32 );
	virtual void			GetPosition(pPoint3& , pVector3& );

#pragma export reset
};


//--------------------------------------------------------
// 3d cylinder
//--------------------------------------------------------

class					pCylinder: public pSpinVolume
{
public:
	pPoint3				base;
	pPoint3				apex;
	float				radius;
	bool				isCapped;

#pragma export on
						pCylinder();
						pCylinder(pPoint3& , pPoint3& , float , bool );
						pCylinder(pCylinder& );
						~pCylinder();

	void				Set(pPoint3& , pPoint3& , float , bool );
	bool				Eq(pCylinder& , float = PIERROT_EPSILON);

	pCylinder&			operator = (pCylinder& );
	int					operator == (pCylinder& );
	int					operator != (pCylinder& );

	virtual pPointsArray*	GenerateSpinDesc(int32 );
	virtual void			GetPosition(pPoint3& , pVector3& );

#pragma export reset
};


//--------------------------------------------------------
// 3d cone
//--------------------------------------------------------

class					pCone: public pSpinVolume
{
public:
	pPoint3				base;
	float				baseRadius;
	pPoint3				apex;
	float				apexRadius;
	bool				isCapped;

#pragma export on
						pCone();
						pCone(pPoint3& , float , pPoint3& , float , bool );
						pCone(pCone& );
						~pCone();

	bool				IsCylinder() const;
	bool				IsPureCone() const;
	void				Set(pPoint3& , float , pPoint3& , float , bool );
	bool				Eq(pCone& , float = PIERROT_EPSILON);

	pCone&				operator = (pCone& );
	int					operator == (pCone& );
	int					operator != (pCone& );

	virtual pPointsArray*	GenerateSpinDesc(int32 );
	virtual void			GetPosition(pPoint3& , pVector3& );

#pragma export reset
};



//--------------------------------------------------------
// 3d torus
//--------------------------------------------------------

class					pTorus: public pSpinVolume
{
public:
	pPoint3				center;
	pVector3			normal;
	float				radius;
	float				a, b;

#pragma export on
						pTorus();
						pTorus(pPoint3& , pVector3& , float , float , float);
						pTorus(pTorus& );
						~pTorus();

	void				Set(pPoint3& , pVector3& , float , float , float);
	bool				Eq(pTorus& , float = PIERROT_EPSILON);

	pTorus&				operator = (pTorus& );
	int					operator == (pTorus& );
	int					operator != (pTorus& );

	virtual pPointsArray*	GenerateSpinDesc(int32 );
	virtual void			GetPosition(pPoint3& , pVector3& );

#pragma export reset
};



//--------------------------------------------------------
// 3d ring
//--------------------------------------------------------

class					pRing: public pSpinVolume
{
public:
	pPoint3				base;
	pVector3			normal;
	float				innerRadius;
	float				outerRadius;

#pragma export on
						pRing();
						pRing(pPoint3& , pVector3& , float , float );
						pRing(pRing& );
						~pRing();

	void				Set(pPoint3& , pVector3& , float , float );
	bool				Eq(pRing& , float = PIERROT_EPSILON);

	pRing&				operator = (pRing& );
	int					operator == (pRing& );
	int					operator != (pRing& );

	virtual pPointsArray*	GenerateSpinDesc(int32 );
	virtual void			GetPosition(pPoint3& , pVector3& );

#pragma export reset
};



//--------------------------------------------------------
// 3d prism
//--------------------------------------------------------
class					pObject;
class					pMaterial;

class					pPrism
{
public:
	PierrotArray<pPoint3 >		base;
	pVector3					direction;
	bool						isCapped;


#pragma export on

						pPrism();
						pPrism(PierrotArray<pPoint3 >& , pVector3& , bool );
						pPrism(pPrism& );
						~pPrism();

	void				Set(PierrotArray<pPoint3 >& , pVector3& , bool );
	bool				Eq(pPrism& , float = PIERROT_EPSILON);

	pPrism&				operator = (pPrism& );
	int					operator == (pPrism& );
	int					operator != (pPrism& );

	pObject*			BuildPrism(char* , pMaterial* , int32 );

#pragma export reset
};


#endif /* _PIERROT_3D_VOLUME_H_ */
