//
//
//	Pierrot color (no alpha component)
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <math.h>
#include "PierrotColor.h"


//--------------------------------------------------------
// RGB spectra
//--------------------------------------------------------

pSpectra::pSpectra()
{}


pSpectra::pSpectra(float _r, float _g, float _b)
{
	r = _r;
	g = _g;
	b = _b;
}



pSpectra::pSpectra(pSpectra& s)
{
	r = s.r;
	g = s.g;
	b = s.b;
}



pSpectra::pSpectra(pColor& c)
{ Set(c); }


pSpectra::~pSpectra()
{}


void
pSpectra::Set(float _r, float _g, float _b)
{
	r = _r;
	g = _g;
	b = _b;
}


void
pSpectra::Set(pColor& c)
{
	r = float(c.r) / 255.0;
	g = float(c.g) / 255.0;
	b = float(c.b) / 255.0;
}


void
pSpectra::Set(pSpectra& s)
{
	r = s.r;
	g = s.g;
	b = s.b;
}


bool
pSpectra::Eq(pSpectra& s, float e)
{
	return (fabs(r - s.r) < e)
		&& (fabs(g - s.g) < e)
		&& (fabs(b - s.b) < e);
}


void
pSpectra::Clamp(float _min, float _max)
{
	r = max_c(min_c(r, _max), _min);
	g = max_c(min_c(g, _max), _min);
	b = max_c(min_c(b, _max), _min);
}


float
pSpectra::GreyLevel()
{
	return 0.39*r + 0.5*g + 0.11*b;
}


pSpectra&
pSpectra::operator*=(float s)
{
	r *= s;
	g *= s;
	b *= s;
	return *this;
}


pSpectra&
pSpectra::operator/=(float s)
{
	r /= s;
	g /= s;
	b /= s;
	return *this;
}


pSpectra
pSpectra::operator*(float s)
{ return pSpectra(r*s, g*s, b*s); }


pSpectra
pSpectra::operator/(float s)
{ return pSpectra(r/s, g/s, b/s); }


pSpectra&
pSpectra::operator+=(pSpectra& s)
{
	r += s.r;
	g += s.g;
	b += s.b;
	return *this;
}


pSpectra&
pSpectra::operator-=(pSpectra& s)
{
	r -= s.r;
	g -= s.g;
	b -= s.b;
	return *this;
}


pSpectra
pSpectra::operator+(pSpectra& s)
{ return pSpectra(r+s.r, g+s.g, b+s.b); }


pSpectra
pSpectra::operator-(pSpectra& s)
{ return pSpectra(r-s.r, g-s.g, b-s.b); }


pSpectra&
pSpectra::operator=(pSpectra& s)
{
	this->Set(s);
	return *this;
}


int
pSpectra::operator==(pSpectra& s)
{ return (r == s.r) && (g == s.g) && (b == s.b); }


int
pSpectra::operator!=(pSpectra& s)
{ return (r != s.r) || (g != s.g) || (b != s.b); }



//--------------------------------------------------------
// RGB color
//--------------------------------------------------------

pColor::pColor()
{}


pColor::pColor(uint8 _r, uint8 _g, uint8 _b)
{
	r = _r;
	g = _g;
	b = _b;
}


pColor::pColor(pColor& s)
{
	r = s.r;
	g = s.g;
	b = s.b;
}


pColor::pColor(pSpectra& s)
{ Set(s); }


pColor::~pColor()
{};


void
pColor::Set(uint8 _r, uint8 _g, uint8 _b)
{
	r = _r;
	g = _g;
	b = _b;
}


void
pColor::Set(pColor& c)
{
	r = c.r;
	g = c.g;
	b = c.b;
}


void
pColor::Set(pSpectra& s)
{
	r = uint8(s.r * 255.0);
	g = uint8(s.g * 255.0);
	b = uint8(s.b * 255.0);
}


bool
pColor::Eq(pColor& c, float e)
{
	return (fabs(r - c.r) < e)
		&& (fabs(g - c.g) < e)
		&& (fabs(b - c.b) < e);
}


void
pColor::Clamp(uint8 _min, uint8 _max)
{
	r = max_c(min_c(r, _max), _min);
	g = max_c(min_c(g, _max), _min);
	b = max_c(min_c(b, _max), _min);
}


uint8
pColor::GreyLevel()
{
	return (99*r + 127*g + 28*b) >> 8;
}


pColor&
pColor::operator=(pColor& s)
{
	this->Set(s);
	return *this;
}


int
pColor::operator==(pColor& s)
{ return (r == s.r) && (g == s.g) && (b == s.b); }


int
pColor::operator!=(pColor& s)
{ return (r != s.r) || (g != s.g) || (b != s.b); }

