//
//
//	Pierrot 3d matrix
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <math.h>
#include "PierrotMatrix.h"



//--------------------------------------------------------
// 3d matrix
//--------------------------------------------------------

pMatrix3::pMatrix3()
{}


pMatrix3::~pMatrix3()
{}


pMatrix3::pMatrix3(pMatrix3& m)
{
	mat[0] = m.GetX();
	mat[1] = m.GetY();
	mat[2] = m.GetZ();
}


pMatrix3::pMatrix3(pVector3& v0, pVector3& v1, pVector3& v2)
{
	mat[0] = v0;
	mat[1] = v1;
	mat[2] = v2;
}


void
pMatrix3::SetX(pVector3& v)
{ mat[0] = v; }


void
pMatrix3::SetY(pVector3& v)
{ mat[1] = v; }


void
pMatrix3::SetZ(pVector3& v)
{ mat[2] = v; }


void
pMatrix3::Set0(pVector3& v)
{
	mat[0].x = v.x;
	mat[1].x = v.y;
	mat[2].x = v.z;
}


void
pMatrix3::Set1(pVector3& v)
{
	mat[0].y = v.x;
	mat[1].y = v.y;
	mat[2].y = v.z;
}


void
pMatrix3::Set2(pVector3& v)
{
	mat[0].z = v.x;
	mat[1].z = v.y;
	mat[2].z = v.z;
}


pVector3&
pMatrix3::GetX()
{ return mat[0]; }


pVector3&
pMatrix3::GetY()
{ return mat[1]; }


pVector3&
pMatrix3::GetZ()
{ return mat[2]; }


void
pMatrix3::Identity()
{
	mat[0].Set(1.0, 0.0, 0.0);
	mat[1].Set(0.0, 1.0, 0.0);
	mat[2].Set(0.0, 0.0, 1.0);
}


void
pMatrix3::Scale(float sx, float sy)
{
	mat[0].x *= sx;
	mat[1].y *= sy;
}


void
pMatrix3::Scale(float sx, float sy, float sz)
{
	mat[0].x *= sx;
	mat[1].y *= sy;
	mat[2].z *= sz;
}



void
pMatrix3::Transpose()
{
	float		tmp;

	PIERROT_MATRIX_SWAP(mat[0].y, mat[1].x);
	PIERROT_MATRIX_SWAP(mat[0].z, mat[2].x);
	PIERROT_MATRIX_SWAP(mat[1].z, mat[2].y);
}


void
pMatrix3::Translate(float tx, float ty)
{
	mat[0].z += tx;
	mat[1].z += ty;
}


pMatrix3&
pMatrix3::operator=(pMatrix3& m)
{
	mat[0] = m.GetX();
	mat[1] = m.GetY();
	mat[2] = m.GetZ();
	return *this;
}


pMatrix3&
pMatrix3::operator+=(pMatrix3& m)
{
	mat[0] += m.GetX();
	mat[1] += m.GetY();
	mat[2] += m.GetZ();
	return *this;
}


pMatrix3&
pMatrix3::operator-=(pMatrix3& m)
{
	mat[0] -= m.GetX();
	mat[1] -= m.GetY();
	mat[2] -= m.GetZ();
	return *this;
}


pMatrix3&
pMatrix3::operator*=(float s)
{
	mat[0] *= s;
	mat[1] *= s;
	mat[2] *= s;
	return *this;
}


pMatrix3&
pMatrix3::operator/=(float s)
{
	mat[0] /= s;
	mat[1] /= s;
	mat[2] /= s;
	return *this;
}


pMatrix3&
pMatrix3::operator*=(pMatrix3& m)
{
	pVector3		v;
	pMatrix3		r;

	v.Set(mat[0].x, mat[1].x, mat[2].x);
	r.Set0(v * m);
	v.Set(mat[0].y, mat[1].y, mat[2].y);
	r.Set1(v * m);
	v.Set(mat[0].z, mat[1].z, mat[2].z);
	r.Set2(v * m);

	*this = r;
	return *this;
}


pMatrix3
pMatrix3::operator~()
{
	return pMatrix3(pVector3(mat[0].x, mat[1].x, mat[2].x),
					pVector3(mat[0].y, mat[1].y, mat[2].y),
					pVector3(mat[0].z, mat[1].z, mat[2].z));
}


pMatrix3
pMatrix3::operator-()
{
	return pMatrix3(mat[0] * -1,
					mat[1] * -1,
					mat[2] * -1);
}


pMatrix3
pMatrix3::operator+(pMatrix3& m)
{
	return pMatrix3(mat[0] + m.GetX(),
					mat[1] + m.GetY(),
					mat[2] + m.GetZ());
}


pMatrix3
pMatrix3::operator-(pMatrix3& m)
{
	return pMatrix3(mat[0] - m.GetX(),
					mat[1] - m.GetY(),
					mat[2] - m.GetZ());
}


pMatrix3
pMatrix3::operator*(float s)
{
	return pMatrix3(mat[0] * s,
					mat[1] * s,
					mat[2] * s);
}


pMatrix3
pMatrix3::operator/(float s)
{
	return pMatrix3(mat[0] / s,
					mat[1] / s,
					mat[2] / s);
}


pMatrix3
pMatrix3::operator*(pMatrix3& m)
{
	pVector3		v;
	pMatrix3		r;

	v.Set(mat[0].x, mat[1].x, mat[2].x);
	r.Set0(v * m);
	v.Set(mat[0].y, mat[1].y, mat[2].y);
	r.Set1(v * m);
	v.Set(mat[0].z, mat[1].z, mat[2].z);
	r.Set2(v * m);

	return r;
}


pMatrix3
pMatrix3::RotateX(float s, float c)
{
	return pMatrix3(pVector3(1.0, 0.0, 0.0),
					pVector3(0.0, c  , -s ),
					pVector3(0.0, s  , c  ));
}


pMatrix3
pMatrix3::RotateY(float s, float c)
{
	return pMatrix3(pVector3(  c, 0.0, s  ),
					pVector3(0.0, 1.0, 0.0),
					pVector3( -s, 0.0, c  ));
}


pMatrix3
pMatrix3::RotateZ(float s, float c)
{
	return pMatrix3(pVector3(  c,  -s, 0.0),
					pVector3(  s,   c, 0.0),
					pVector3(0.0, 0.0, 1.0));
}


// rotate the vector named "axys" to the Z axys
pMatrix3
pMatrix3::RotateToZ(pVector3& axys)
{
	float		tmp1, tmp2;
	float		cosA, sinA;
	float		cosB, sinB;

	tmp1 = axys.x*axys.x + axys.z*axys.z;
	tmp2 = tmp1 + axys.y*axys.y;
	tmp1 = sqrt(tmp1);			// (x^2 + z^2)^.5
	tmp2 = sqrt(tmp2);			// (x^2 + y^2 + z^2)^.5

	if (tmp1 != 0.0)
	{
		cosA = axys.z / tmp1;
		sinA = axys.x / tmp1;
	}
	else
	{
		cosA = 1.0;
		sinA = 0.0;
	}
	cosB = tmp1 / tmp2;
	sinB = axys.y / tmp2;

	pMatrix3		Ry = pMatrix3::RotateY(-sinA, cosA);
	pMatrix3		Rx = pMatrix3::RotateX( sinB, cosB);

	return Ry * Rx;
}

