//
//
//	Pierrot viewing system
//
//										(C) JoOl 1998


#include "PierrotImpExp.h"

#include <math.h>
#include "PierrotViewSys.h"



pViewSys::pViewSys()
{
	SetDefault();
}


pViewSys::~pViewSys()
{
}

/*
pVector3
pViewSys::GetU()
{ return u; }


pVector3
pViewSys::GetV()
{ return v; }


pVector3
pViewSys::GetN()
{ return n; }


pVector3
pViewSys::GetT()
{ return pVector3(origin.x, origin.y, origin.z); }
*/

void
pViewSys::SetDefault()
{
	SetTo(1.5, pPoint3(0.0, 0.0, 0.0));
}


void
pViewSys::SetTo(float dist, pPoint3& targ)
{
	distance = dist;
	target = targ;

	origin.Set(0.0, 0.0, -distance);

	n.Set(origin, target);
	n.Norm();

	pVector3		vPrime(0.0, 1.0, 0.0);
	v = vPrime - n*(vPrime*n);
	v.Norm();
//	u = n ^ v;		// left-handed system
	u = v ^ n;		// right-handed system
}


void
pViewSys::SetTo(pPoint3& from, pPoint3& to, float twist)
{
	pMatrix3			twistMat = pMatrix3::RotateZ(sin(twist), cos(twist));

	n.Set(from, to);
	distance = n.Length();
	origin = from;
	target = to;
	n.Set(origin, target);
	n.Norm();

	pVector3		vPrime(0.0, 1.0, 0.0);
	v = vPrime - n*(vPrime*n);
	v.Norm();
	v *= twistMat;
//	u = n ^ v;		// left-handed system
	u = v ^ n;		// right-handed system
}


void
pViewSys::Rotate(pVector3& axys, float angle)
{
	pMatrix3		Rz = pMatrix3::RotateZ(sin(angle), cos(angle));
	pMatrix3		N = pMatrix3::RotateToZ(axys);

	pMatrix3		M = N * Rz * ~N;
	v *= M;
	n *= M;
//	u = n ^ v;		// left-handed system
	u = v ^ n;		// right-handed system !
	origin = target - n * distance;
}


void
pViewSys::RotateU(float angle)
{
	Rotate(u, angle);
}


void
pViewSys::RotateV(float angle)
{
	Rotate(v, angle);
}


void
pViewSys::RotateN(float angle)
{
	Rotate(n, angle);
}


void
pViewSys::Zoom(float step)
{
	distance += step;
	origin = target - n * distance;
}


void
pViewSys::BuildMatrix()
{
	float*			ptr = matrix;

	*ptr++ = u.x;
	*ptr++ = v.x;
	*ptr++ = n.x;
	*ptr++ = 0.0;

	*ptr++ = u.y;
	*ptr++ = v.y;
	*ptr++ = n.y;
	*ptr++ = 0.0;

	*ptr++ = u.z;
	*ptr++ = v.z;
	*ptr++ = n.z;
	*ptr++ = 0.0;

	*ptr++ = origin * u;
	*ptr++ = origin * v;
	*ptr++ = origin * n;
	*ptr++ = 1.0;
}


void
pViewSys::BuildMatrix2()
{
	float*			ptr = matrix;

	*ptr++ = u.x;
	*ptr++ = u.y;
	*ptr++ = u.z;
	*ptr++ = origin * u;

	*ptr++ = v.x;
	*ptr++ = v.y;
	*ptr++ = v.z;
	*ptr++ = origin * v;

	*ptr++ = n.x;
	*ptr++ = n.y;
	*ptr++ = n.z;
	*ptr++ = origin * n;

	*ptr++ = 0.0;
	*ptr++ = 0.0;
	*ptr++ = 0.0;
	*ptr++ = 1.0;
}


float*
pViewSys::GetMatrix()
{
	return matrix;
}


int32
pViewSys::operator == (pViewSys& vs)
{
	return	(distance == vs.distance)
			&& (target == vs.target)
			&& (origin == vs.origin)
			&& (u == vs.u)
			&& (v == vs.v)
			&& (n == vs.n);
}


int32
pViewSys::operator != (pViewSys& vs)
{
	return	(distance != vs.distance)
			|| (target != vs.target)
			|| (origin != vs.origin)
			|| (u != vs.u)
			|| (v != vs.v)
			|| (n != vs.n);
}

