//
//
//	Plain add-on
//
//										(C) JoOl 1998


#include "PlainAddOn.h"




PlainAddOn*
NewPlainAddOn()
{
	return new PlainAddOn();
}



PlainAddOn::PlainAddOn()
: RstringItem("", "")
{
	image = -1;
}


PlainAddOn::~PlainAddOn()
{
	Unset();
}


void
PlainAddOn::Unset()
{
	if (image >= 0)
	{
/*		printf("unload %s: ", ref.name);
		if (unload_add_on(image) == B_NO_ERROR)
			printf("okette\n");
		else
			printf("gruik!\n");
*/
		unload_add_on(image);
		image = -1;
	}
}


image_id
PlainAddOn::GetImage() const
{
	return image;
}


entry_ref
PlainAddOn::GetRef() const
{
	return ref;
}


entry_ref
PlainAddOn::GetLinkRef() const
{
	return linkRef;
}


node_ref
PlainAddOn::GetNodeRef() const
{
	return nodeRef;
}


node_ref
PlainAddOn::GetLinkNodeRef() const
{
	return linkNodeRef;
}


bool
PlainAddOn::SetTo(char* path)
{
	BEntry			e;

	e.SetTo(path, false);
	if (e.InitCheck() != B_NO_ERROR)
		return false;
	e.GetRef(&ref);
	e.GetNodeRef(&nodeRef);

	e.SetTo(path, true);
	if (e.InitCheck() != B_NO_ERROR)
		return false;
	e.GetRef(&linkRef);
	e.GetNodeRef(&linkNodeRef);

	SetId(ref.name);
	SetLabel(ref.name);

	image = load_add_on(path);
	return image >= 0;
}


bool
PlainAddOn::Eq(entry_ref* r)
{
	return (ref == *r) || (linkRef == *r);
}


bool
PlainAddOn::Eq(node_ref* nr)
{
	return (nodeRef == *nr) || (linkNodeRef == *nr);
}

