//
//
//	Am@chi messages window
//
//											(C) JoOl 1998


#include <Application.h>
#include <Window.h>
#include <View.h>
#include <Box.h>
#include <Button.h>
#include "LAPcommon.h"
#include "MessagesWindow.h"
#include "RiconedStringItem.h"


MessagesWindow::MessagesWindow(BRect frame, const char* name, window_look look,
							window_feel feel, uint32 flags, uint32 wkspaces)
: BWindow(frame, name, look, feel, flags, wkspaces)
{
	messageIcons[AMACHI_INFO_ICON] = NULL;
	messageIcons[AMACHI_WARNING_ICON] = NULL;
	messageIcons[AMACHI_ERROR_ICON] = NULL;


	BRect			fr;

	// window's background view
	fr = Bounds();
	BView*				bgv = new BView(fr, "SetupWindow_bg", B_FOLLOW_ALL,
										B_WILL_DRAW | B_FRAME_EVENTS);
	bgv->SetViewColor(220, 220, 220, 0);
	this->AddChild(bgv);

	// list of messages
	fr = bgv->Bounds();
	fr.InsetBy(5.0, 5.0);
	BBox*		box = new BBox(fr, "messagesBox", B_FOLLOW_ALL,
							B_WILL_DRAW | B_FRAME_EVENTS, B_FANCY_BORDER);
	bgv->AddChild(box);
	BuildMessagesRoster(box);
}


MessagesWindow::~MessagesWindow()
{
	if (messageIcons[AMACHI_INFO_ICON])
		delete messageIcons[AMACHI_INFO_ICON];
	if (messageIcons[AMACHI_WARNING_ICON])
		delete messageIcons[AMACHI_WARNING_ICON];
	if (messageIcons[AMACHI_ERROR_ICON])
		delete messageIcons[AMACHI_ERROR_ICON];
}


MessagesRoster*
MessagesWindow::GetMessagesRoster() const
{
	return messagesRoster;
}


void
MessagesWindow::SetMessageIcons(BBitmap* err, BBitmap* wrn, BBitmap* inf)
{
	messageIcons[AMACHI_ERROR_ICON] = err;
	messageIcons[AMACHI_WARNING_ICON] = wrn;
	messageIcons[AMACHI_INFO_ICON] = inf;
}


bool
MessagesWindow::QuitRequested()
{
	if (!IsHidden())
		Hide();
	return false;
}


void
MessagesWindow::MessageReceived(BMessage* msg)
{
	if (msg->HasRef("refs"))
	{
		be_app->RefsReceived(msg);
		return;
	}

	char*				msgString = NULL;
	int32				msgLength = 0;
	int32				msgType = LAP_NO_MESSAGE;
	int32				msgIcon = -1;
	RiconedStringItem*	msgItem = NULL;
	int32				itemIndex = -1;
	int32				all = -1;

	switch (msg->what)
	{
		// message-related messages
		case AMACHI_NEW_MESSAGE:
			msg->FindString("buffer", &msgString);
			msg->FindInt32("buffer_length", &msgLength);
			msg->FindInt32("msg_type", &msgType);
			msgIcon = AMACHI_INFO_ICON;
			if (msgType == LAP_WARNING_MESSAGE)
				msgIcon = AMACHI_WARNING_ICON;
			else if (msgType == LAP_ERROR_MESSAGE)
				msgIcon = AMACHI_ERROR_ICON;
			msgString[msgLength] = 0;

			messagesRoster->AddItem(messageIcons[msgIcon], msgString);
			delAllMessagesButton->SetEnabled(true);
/*			if (IsHidden())
				Show();
*/			break;

		case AMACHI_SELECT_MESSAGE:
			itemIndex = messagesRoster->CurrentSelection();
			if (itemIndex >= 0)
				msgItem = (RiconedStringItem* )messagesRoster->ItemAt(itemIndex);
			delMessageButton->SetEnabled(itemIndex >= 0);
			if (msgItem)
			{
				printf("select message %d\n", itemIndex);
			}
			break;

		case AMACHI_DELETE_MESSAGE:
			msg->FindInt32("all", &all);
			if (all > 0)
			{
				messagesRoster->DeleteItems();
				delMessageButton->SetEnabled(false);
				delAllMessagesButton->SetEnabled(false);
			}
			else
			{
				itemIndex = messagesRoster->CurrentSelection();
				if (itemIndex >= 0)
				{
					messagesRoster->DeleteItem(itemIndex);
					delMessageButton->SetEnabled(false);
					if (messagesRoster->CountItems() < 1)
						delAllMessagesButton->SetEnabled(false);
				}
			}
			break;

		default:
			BWindow::MessageReceived(msg);
			break;
	}
}


void
MessagesWindow::BuildMessagesRoster(BBox* box)
{
	BRect			fr = box->Bounds();
	fr.InsetBy(10.0, 15.0);
	fr.OffsetBy(0.0, 5.0);
	fr.bottom -= 30.0;
	BListView*			lv = new BListView(fr, "messagesList", B_SINGLE_SELECTION_LIST,
										B_FOLLOW_ALL, /*B_FOLLOW_LEFT_RIGHT | B_FOLLOW_TOP,*/
										B_WILL_DRAW | B_FRAME_EVENTS);
	lv->SetSelectionMessage(new BMessage(AMACHI_SELECT_MESSAGE));
	messagesRoster = new MessagesRoster(lv, "messagesList", IL_SCROLL_ALL);
	box->AddChild(messagesRoster);
	box->SetLabel("Messages");

	BMessage*			msg;

	msg = new BMessage(AMACHI_DELETE_MESSAGE);
	fr = messagesRoster->Frame();
	fr.OffsetBy(0.0, fr.Height() + 8.0);
	fr.SetRightBottom(BPoint(fr.left + 60.0, fr.top + 20.0));
	delMessageButton = new BButton(fr, "delSceneButton", "Delete", msg,
								B_FOLLOW_LEFT | B_FOLLOW_BOTTOM, B_WILL_DRAW);
	delMessageButton->SetEnabled(false);
	box->AddChild(delMessageButton);

	msg = new BMessage(AMACHI_DELETE_MESSAGE);
	msg->AddInt32("all", 1);
	fr.OffsetBy(fr.Width() + 10.0, 0.0);
	delAllMessagesButton = new BButton(fr, "delSceneButton", "Delete all", msg,
								B_FOLLOW_LEFT | B_FOLLOW_BOTTOM, B_WILL_DRAW);
	delAllMessagesButton->SetEnabled(false);
	box->AddChild(delAllMessagesButton);
}
