//
//
//	Regular items list
//
//										(C) JoOl 1998


#ifndef _REGULAR_ITEMS_LIST_H_
#define _REGULAR_ITEMS_LIST_H_


#include <View.h>
#include <ListView.h>
#include <ScrollBar.h>
#include "PitemsList.h"
#include "Ritem.h"


class					RitemsList: public PitemsList
{
	float				ComputeItemsWidth() const;

protected:

	BListView*			_list;

public:

						RitemsList(	BListView* , const char* ,
									uint32 = IL_NO_SCROLL);
	virtual				~RitemsList();

	BRect				ItemFrame(int32 );
	void				MakeEmpty();
	void				MakeFocus(bool = true);
	void				ScrollTo(BPoint );
	void				ScrollToSelection();

	int32				CurrentSelection(int32 = 0) const;
	void				Deselect(int32 );
	void				DeselectAll();
	void				DeselectExcept(int32 , int32 );
	BMessage*			InvocationMessage() const;
	uint32				InvocationCommand() const;
	void				SetSelectionMessage(BMessage *);
	void				SetInvocationMessage(BMessage *);
	BMessage*			SelectionMessage() const;
	uint32				SelectionCommand() const;
	void				Select(int32 , bool = false);
	void				Select(int32 , int32 , bool = false);
	bool				IsItemSelected(int32 ) const;

	bool				IsEmpty() const;
	int32				CountItems() const;
	Ritem*				ItemAt(int32 ) const;
	int32				IndexOf(Ritem* ) const;
	int32				IndexOf(BPoint ) const;
	int32				Search(Ritem* ) const;
	int32				Search(PitemsCmpFunc , void* ) const;
	bool				Exists(Ritem* ) const;
	bool				Exists(PitemsCmpFunc , void* ) const;
	bool				MoveItem(int32 , int32 );
	bool				SwapItems(int32 , int32 );

	bool				AddItem(Ritem* , int32 i = -1);
	bool				AddItem(PitemsCmpFunc , Ritem* , int32 i = -1);
	bool				DeleteItem(int32 );
	bool				DeleteItem(PitemsCmpFunc , void* );
	void				DeleteItems();
	Ritem*				RemoveItem(int32 );
	Ritem*				RemoveItem(PitemsCmpFunc , void* );
};


#endif	/* _REGULAR_ITEMS_LIST_H_ */
