//
//
//	Plain items list
//
//											(C) JoOl 1998

#include <string.h>
#include <stdio.h>
#include <ScrollBar.h>
#include "PitemsList.h"



PitemsList::PitemsList(BView* v, const char* n, uint32 sbars)
: BView(v->Frame(), NULL, v->ResizingMode(), v->Flags())
{
	BRect			tmpRect;
	char*			tmpName = new char[strlen(v->Name()) + 8 + 1];

	sprintf(tmpName, "%s_view", v->Name());
	this->SetName(tmpName); 

	itemsView = v;
	itemsView->MoveTo(B_ORIGIN);
	this->AddChild(itemsView);

	hSbar = vSbar = NULL;

	if (sbars & IL_H_SCROLL)
		itemsView->ResizeBy(0.0, -B_H_SCROLL_BAR_HEIGHT -1.0);
	if (sbars & IL_V_SCROLL)
		itemsView->ResizeBy(-B_V_SCROLL_BAR_WIDTH -1.0, 0.0);

	sbarFlags = sbars;
	sbarFlags &= ~IL_H_SCROLL;
	sbarFlags &= ~IL_V_SCROLL;
	if (sbars & IL_H_SCROLL)
	{
		sprintf(tmpName, "%s_hSbar", itemsView->Name());
		tmpRect = itemsView->Bounds();
		tmpRect.top = tmpRect.bottom + 1.0;
		tmpRect.bottom = tmpRect.top + B_H_SCROLL_BAR_HEIGHT;
		tmpRect.right += 1.0;
		hSbar = new BScrollBar(tmpRect, tmpName, itemsView, 0.0, 0.0, B_HORIZONTAL);
		this->AddChild(hSbar);
	}

	if (sbars & IL_V_SCROLL)
	{
		sprintf(tmpName, "%s_vSbar", itemsView->Name());
		tmpRect = itemsView->Bounds();
		tmpRect.left = tmpRect.right + 1.0;
		tmpRect.right = tmpRect.left + B_V_SCROLL_BAR_WIDTH;
		tmpRect.bottom += 1.0;
		vSbar = new BScrollBar(tmpRect, n, itemsView, 0.0, 0.0, B_VERTICAL);
		this->AddChild(vSbar);
	}

	itemsCount = 0;
	itemsHeight = itemsWidth = 0.0;

	itemColor1.red = 240;
	itemColor1.green = 240;
	itemColor1.blue = 240;
	itemColor1.alpha = 0;

	itemColor2.red = 235;
	itemColor2.green = 235;
	itemColor2.blue = 235;
	itemColor2.alpha = 0;

	delete[] tmpName;
}


PitemsList::~PitemsList()
{
}


void
PitemsList::UpdateScrollBars(float w, float h)
{
	if (hSbar)
	{
		float			a = (vSbar && !vSbar->IsHidden()) ? B_V_SCROLL_BAR_WIDTH : 0.0;
		if (sbarFlags & IL_H_SCROLL_AS_NEEDED)
		{
			if (sbarFlags & IL_H_SCROLL)
			{
				if (w-a < itemsWidth)
				{
					hSbar->Show();
					sbarFlags &= ~IL_H_SCROLL;
					itemsView->ResizeBy(0.0, -B_H_SCROLL_BAR_HEIGHT);
					if (vSbar)
						vSbar->ResizeBy(0.0, -B_H_SCROLL_BAR_HEIGHT);
				}
			}
			else
			{
				if (w-a > itemsWidth)
				{
					hSbar->Hide();
					sbarFlags |= IL_H_SCROLL;
					itemsView->ResizeBy(0.0, B_H_SCROLL_BAR_HEIGHT);
					if (vSbar)
						vSbar->ResizeBy(0.0, B_H_SCROLL_BAR_HEIGHT);
				}
			}
		}

		hSbar->SetSteps(itemsView->Bounds().Width() * 0.25, itemsView->Bounds().Width());
 		hSbar->SetRange(0.0, max_c(itemsWidth - itemsView->Bounds().Width() + a + 4.0, 0.0));
		if (itemsWidth != 0.0)
			hSbar->SetProportion((itemsView->Bounds().Width()-a) / itemsWidth);
	}

	if (vSbar)
	{
		float			a = (hSbar && !hSbar->IsHidden()) ? B_H_SCROLL_BAR_HEIGHT : 0.0;
		if (sbarFlags & IL_V_SCROLL_AS_NEEDED)
		{
			if (sbarFlags & IL_V_SCROLL)
			{
				if (h-a < itemsHeight)
				{
					vSbar->Show();
					sbarFlags &= ~IL_V_SCROLL;
					itemsView->ResizeBy(-B_V_SCROLL_BAR_WIDTH, 0.0);
					if (hSbar)
						hSbar->ResizeBy(-B_V_SCROLL_BAR_WIDTH, 0.0);
				}
			}
			else
			{
				if (h-a > itemsHeight)
				{
					vSbar->Hide();
					sbarFlags |= IL_V_SCROLL;
					itemsView->ResizeBy(B_V_SCROLL_BAR_WIDTH, 0.0);
					if (hSbar)
						hSbar->ResizeBy(B_V_SCROLL_BAR_WIDTH, 0.0);
				}
			}
		}

		vSbar->SetSteps(itemsView->Bounds().Height() * 0.25, itemsView->Bounds().Height());
		vSbar->SetRange(0.0, max_c(itemsHeight - itemsView->Bounds().Height() + float(itemsCount) - 1.0, 0.0));
		if (itemsHeight != 0.0)
			vSbar->SetProportion(itemsView->Bounds().Height() / itemsHeight);
	}
}


void
PitemsList::AttachedToWindow()
{
	BView::AttachedToWindow();

	if (Parent())
		SetViewColor(Parent()->ViewColor());

	BRect			bounds = this->Bounds();
	UpdateScrollBars(bounds.Width(), bounds.Height());
}


void
PitemsList::FrameResized(float w, float h)
{
//	BView::FrameResized(w, h);

	UpdateScrollBars(w, h);
}


void
PitemsList::SetItemsColor(const rgb_color& c1, const rgb_color& c2)
{
	itemColor1 = c1;
	itemColor2 = c2;
}


rgb_color
PitemsList::ColorFor(int32 index) const
{
	return (index & 0x01) ? itemColor1 : itemColor2;
}

