//
//
//	Regular list string item
//
//											(C) JoOl 1998


#include <malloc.h>
#include <string.h>
#include <stdio.h>
#include "RstringItem.h"


RstringItem::RstringItem(char* i, char* lbl, uint32 lvl, bool exp)
: Ritem(i, lvl, exp)
{
	label = NULL;
	SetLabel(lbl);
}


RstringItem::~RstringItem()
{
	if (label)
		delete[] label;
}


void
RstringItem::SetLabel(char* lbl)
{
	if (label)
		delete label;
	label = new char[strlen(lbl)+1];
	strcpy(label, lbl);
}


char*
RstringItem::GetLabel() const
{
	return label;
}


void
RstringItem::DrawItem(BView* owner, BRect itemRect, bool drawEverything)
{
	BFont			font;
	owner->SetFont(be_plain_font);
	owner->GetFont(&font);

	owner->SetDrawingMode(B_OP_COPY);
	if (IsSelected())
		owner->SetHighColor(200, 200, 200, 0);
	else
		owner->SetHighColor(viewColor);
//		owner->SetHighColor(owner->ViewColor());
	owner->FillRect(itemRect);

	if (!IsEnabled())
		owner->SetHighColor(150, 150, 150, 0);
	else
		owner->SetHighColor(0, 0, 0, 0);

	BPoint			base(itemRect.left + 2.0,
						itemRect.bottom - 1.0 - (itemRect.Height()-font.Size())*0.5);
	owner->MovePenTo(base);
	owner->DrawString(label);
}


void
RstringItem::Update(BView* owner, const BFont* font)
{
	SetHeight(font->Size() + 2.0);
	SetWidth(2.0 + font->StringWidth(label) + 2.0);
}

