//
//
//	Scene list item
//
//										(C) JoOl 1998


#include <Path.h>
#include <File.h>
#include <NodeInfo.h>
#include <Bitmap.h>
#include "SceneItem.h"



SceneItem::SceneItem(entry_ref ref, pScene* scn)
:RstringItem("", ref.name),
 miniIcon(NULL),
 scene(scn),
 configView(NULL)
{
	BPath			path;
	BEntry			entry(&ref, true);
	entry.GetPath(&path);

	SetId((char* )path.Path());
	miniIcon = NULL;

	// retrieve the file's icon
	BFile			file(path.Path(), B_READ_ONLY);
	if (file.InitCheck() == B_NO_ERROR)
	{
		BNodeInfo		mime(&file);
		if (mime.InitCheck() == B_NO_ERROR)
		{
			miniIcon = new BBitmap(BRect(0, 0, 15.0, 15.0),
									B_COLOR_8_BIT);
			if (mime.GetTrackerIcon(miniIcon, B_MINI_ICON) != B_NO_ERROR)
				delete miniIcon;
		}
	}

	scene->viewsys.SetDefault();
	config.SetDefault();
}


SceneItem::~SceneItem()
{
	if (scene)
		delete scene;
	if (miniIcon)
		delete miniIcon;
}


void
SceneItem::SetConfig(GLconfig& conf)
{
	config = conf;
}


void
SceneItem::SetConfigView(AmachiGLConfig* c)
{
	configView = c;
}


pScene*
SceneItem::GetScene() const
{
	return scene;
}


GLconfig*
SceneItem::GetConfig()
{
	return &config;
}


AmachiGLConfig*
SceneItem::GetConfigView() const
{
	return configView;
}


void
SceneItem::DrawItem(BView* owner, BRect itemRect, bool drawEverything)
{
	BFont			font;
	owner->SetFont(be_plain_font);
	owner->GetFont(&font);

	float			iw = 16.0;
	float			ih = 16.0;
	if (miniIcon)
	{
		iw = miniIcon->Bounds().Width();
		ih = miniIcon->Bounds().Height();
	}
	BPoint			iconPt(itemRect.left + 2.0,
							itemRect.top + 2.0);
	BPoint			labelPt(iconPt.x + iw + 6.0,
							itemRect.top + (ih+font.Size())*0.5 + 2.0);

	BRect			labelRect = itemRect;
	owner->SetDrawingMode(B_OP_COPY);
	if (IsSelected())
		owner->SetHighColor(200, 200, 200, 0);
	else
		owner->SetHighColor(viewColor);
	owner->FillRect(labelRect);

	if (miniIcon)
	{
		owner->SetDrawingMode(B_OP_OVER);
		owner->SetLowColor(B_TRANSPARENT_32_BIT);
		owner->DrawBitmap(miniIcon, iconPt);
	}

	owner->SetDrawingMode(B_OP_COPY);
	if (!IsEnabled())
		owner->SetHighColor(150, 150, 150, 0);
	else
		owner->SetHighColor(0, 0, 0, 0);
	owner->SetLowColor(255, 255, 255, 0);
	owner->MovePenTo(labelPt);
	owner->DrawString(label);
}


void
SceneItem::Update(BView* owner, const BFont* font)
{
	SetHeight(25.0);
	SetWidth(2.0 + miniIcon->Bounds().Width() + 2.0 + font->StringWidth(label) + 2.0);
}
