//
//
//	CD buttons
//
//											(C) JoOl 1998

#include "CdButton.h"


CdButton::CdButton(BRect frm, char* nam, uint32 rm, uint32 flg)
: BButton(frm, nam, "", NULL, rm, flg)
{
	value = Value();

	msgOn = msgOff = NULL;

	ResizeTo(frm.Width(), frm.Height());
}


CdButton::~CdButton()
{
	if (msgOn)
		delete msgOn;
	if (msgOff)
		delete msgOff;
}


void
CdButton::SetButtonValue(int32 val)
{
	value = val;
	if (Parent())
		Draw(Bounds());
}


void
CdButton::SetMessages(BMessage* mon, BMessage* moff, BHandler* trgt)
{
	if (msgOn)
		delete msgOn;
	if (msgOff)
		delete msgOff;
	msgOn = mon;
	msgOff = moff;
	SetTarget(trgt);
}


void
CdButton::MouseDown(BPoint where)
{
	BPoint			cursor;
	uint32			buttons;
	GetMouse(&cursor, &buttons, true);

	if (buttons & B_PRIMARY_MOUSE_BUTTON)
	{
		if (!IsEnabled())
			return ;

		// shade the button
		SetDrawingMode(B_OP_SUBTRACT);
		SetHighColor(40, 40, 40);
			BRect			bnds = Bounds();
		bnds.InsetBy(1.0, 1.0);
		FillRect(bnds);

		// track mouse button
		for (;;)
		{
			GetMouse(&cursor, &buttons, true);
			if (!(buttons & B_PRIMARY_MOUSE_BUTTON))
				break ;
			snooze(100.0 * 1000.0);
		}

		// toggle the value if the cursor is the button bounds
		if (Bounds().Contains(cursor))
		{
			BMessage*		msg = (value == B_CONTROL_ON) ? msgOn : msgOff;
			Invoke(msg);
			value = (value == B_CONTROL_ON) ? B_CONTROL_OFF : B_CONTROL_ON;
		}
		Draw(Bounds());
	}
}


BRect
CdButton::ButtonBounds()
{
	BRect			bnds = Bounds();
	int16			iw = bnds.IntegerWidth();
	int16			ih = bnds.IntegerHeight();
	int16			siz = min_c(iw-8, ih-8);
	siz = (siz & ~0x01) - 1;

	BRect			out(0.0, 0.0, float(siz), float(siz));
	out.OffsetBy(float((iw-siz) >> 1), float((ih-siz) >> 1));
	return out;
}


//----------------------------------------------
// Play & Pause CD button
//----------------------------------------------
CdPlayPauseButton::CdPlayPauseButton(BRect frm, char* nam, uint32 rm, uint32 flg)
: CdButton(frm, nam, rm, flg)
{
}


CdPlayPauseButton::~CdPlayPauseButton()
{
}


void
CdPlayPauseButton::Draw(BRect updateRect)
{
	SetDrawingMode(B_OP_COPY);
	SetPenSize(1.0);
	BButton::Draw(updateRect);

	BRect			bnds = ButtonBounds();

	if (IsEnabled())
		SetHighColor(0, 0, 0, 0);
	else
		SetHighColor(150, 150, 150, 0);

	if (value == B_CONTROL_ON)
	{
		bnds.InsetBy(2.0, 1.0);
		BRect			poz;
		float			siz = bnds.Width()*0.25;
		poz.Set(bnds.left,		bnds.top,
				bnds.left+siz,	bnds.bottom);
		FillRect(poz);
		poz.OffsetBy(siz*3.0, 0.0);
		FillRect(poz);
	}
	else
	{
		float			siz = float(bnds.IntegerHeight() & ~0x01)*0.5;
		bnds.top += 1.0;
		bnds.left += float((bnds.IntegerWidth() + 3) >> 2);
		FillTriangle(	bnds.LeftTop(),
						BPoint(bnds.left + siz, bnds.top + siz),
						BPoint(bnds.left, bnds.top + siz*2.0));
	}
}


//----------------------------------------------
// Stop CD button
//----------------------------------------------
CdStopButton::CdStopButton(BRect frm, char* nam, uint32 rm, uint32 flg)
: CdButton(frm, nam, rm, flg)
{
}


CdStopButton::~CdStopButton()
{
}


void
CdStopButton::Draw(BRect updateRect)
{
	SetDrawingMode(B_OP_COPY);
	SetPenSize(1.0);
	BButton::Draw(updateRect);

	BRect			bnds = ButtonBounds();

	if (IsEnabled())
		SetHighColor(0, 0, 0, 0);
	else
		SetHighColor(150, 150, 150, 0);

	bnds.InsetBy(2.0, 2.0);
	FillRect(bnds);
}


//----------------------------------------------
// Kill CD button
//----------------------------------------------
CdKillButton::CdKillButton(BRect frm, char* nam, uint32 rm, uint32 flg)
: CdButton(frm, nam, rm, flg)
{
}


CdKillButton::~CdKillButton()
{
}


void
CdKillButton::Draw(BRect updateRect)
{
	SetDrawingMode(B_OP_COPY);
	SetPenSize(1.0);
	BButton::Draw(updateRect);

	BRect			bnds = ButtonBounds();

	if (IsEnabled())
		SetHighColor(0, 0, 0, 0);
	else
		SetHighColor(150, 150, 150, 0);

	SetPenSize(bnds.Width()*0.25);
	bnds.InsetBy(1.0, 1.0);
	StrokeLine(bnds.LeftTop(), bnds.RightBottom());
	StrokeLine(bnds.RightTop(), bnds.LeftBottom());
}
