//
//
//	AOFF lexer class
//
//											(C) JoOl 1998


#include "LexerAoff.h"



LexerAoff::LexerAoff(int32 blen, LAPlexemeBuffer* lb)
: LAPtextLexer(blen, lb)
{
}


LexerAoff::~LexerAoff()
{
}


void
LexerAoff::SetCharCodes()
{
	SetDefaultCharCodes();
//	SetCharCode(0xd, LAP_CHAR_SPACE);
	SetCharCode('.', LAP_CHAR_ALPHA);
	SetCharCode('-', LAP_CHAR_ALPHA);
}


void
LexerAoff::SetLexemes()
{
	lexemes.Insert(new LAPlexeme("name", TOKEN_NAME));
		lexemes.Insert(new LAPlexeme("description", TOKEN_DESCRIPTION));
		lexemes.Insert(new LAPlexeme("copyright", TOKEN_COPYRIGHT));
		lexemes.Insert(new LAPlexeme("type", TOKEN_TYPE));
			lexemes.Insert(new LAPlexeme("polygon", TOKEN_POLYGON));

		lexemes.Insert(new LAPlexeme("default", TOKEN_DEFAULT));
		lexemes.Insert(new LAPlexeme("s", TOKEN_S));
		lexemes.Insert(new LAPlexeme("fff", TOKEN_FFF));
		lexemes.Insert(new LAPlexeme("indexed", TOKEN_INDEXED));
		lexemes.Insert(new LAPlexeme("generic", TOKEN_GENERIC));

		lexemes.Insert(new LAPlexeme("geometry", TOKEN_GEOMETRY));
			lexemes.Insert(new LAPlexeme("indexed_poly", TOKEN_INDEXED_POLY));
		lexemes.Insert(new LAPlexeme("back_faces", TOKEN_BACKFACES));
		lexemes.Insert(new LAPlexeme("polygon_colors", TOKEN_POLYGON_COLORS));
		lexemes.Insert(new LAPlexeme("vertex_order", TOKEN_VERTEX_ORDER));
			lexemes.Insert(new LAPlexeme("clockwise", TOKEN_CLOCKWISE));
			lexemes.Insert(new LAPlexeme("counter-clockwise", TOKEN_COUNTER_CLOCKWISE));
}


LAPtoken
LexerAoff::_NextToken()
{
	for (;;)
	{
		if (input->Eof())
			return LAP_TOKEN_EOF;

		char			currentCharacter = input->Peek();

		// deal with numbers (both positive and negative integers or floats)
		if (IsDigit(currentCharacter) || (currentCharacter == '.'))
		{
			LexNumber();
			return token;
		}
		if (currentCharacter == '-')
		{
			Fwd();
			LexNumber();
			return token;
		}

		// deal with identifiers and lexemes
		if (IsAlpha(currentCharacter))
		{
			LexIdentifier();
			return token;
		}

		// deal with spaces
		if (IsSpace(currentCharacter))
		{
			SkipSpaces();
			continue;
		}

		if (currentCharacter == '#')
		{
			SkipLine();
			continue;
		}

		ProcessIllegal(currentCharacter);
	}
}

