//
//
//	COB objects parser
//
//										(C) JoOl 1998


#ifndef _PARSER_COB_H_
#define _PARSER_COB_H_


#include "LAPbinParser.h"
#include "PierrotParser.h"
#include "LAPerrors.h"
#include "PierrotColor4.h"


enum
{
	COB_MISMATCH_CHUNK		= LAP_ERROR_LAST
};


typedef struct
{
	int32				chunkType;
	int16				majorVersion;
	int16				minorVersion;
	int32				chunkId;
	int32				parentId;
	int32				chunkLen;		// can be -1 when size is unknown
} CobChunk;


class					CobMismatchChunk: public LAPparserException
{
public:
	int32				expectedType;
	int32				expectedMajorVersion;
	int32				expectedMinorVersion;
	int32				actualType;
	int32				actualMajorVersion;
	int32				actualMinorVersion;

						CobMismatchChunk(const char* ,
										int32 , int32 , int32 , CobChunk& );
						CobMismatchChunk(CobMismatchChunk& );
	virtual				~CobMismatchChunk();

	virtual void		Output(LAPtextBufferedOutput& );
};



class						ParserCob : public LAPbinParser, public PierrotParser
{

	status_t				ParseHeader();

	void					ParseChunkHeader(CobChunk& );
	void					SkipChunk(CobChunk& );
	void					Match(CobChunk& , int32 , int32 , int32 );
	void					OutputChunk(CobChunk& );

	char*					ParseString();
	char*					ParseName();
	void					ParsePoint(pPoint3& );
	void					ParseVector(pVector3& );
	void					ParseVector(pVector4& );
	void					ParseColor(pSpectra& );
	void					ParseColor(pSpectra4& );
	void					ParseLocalAxis(pMatrix4& );
	void					ParsePosition(pMatrix4& );


	enum
	{
		CHUNK_END					= 'END ',
		CHUNK_GROUP					= 'Grou',
			GROUP_MAJOR				= 0,
			GROUP_MINOR				= 1,
		CHUNK_UNIT					= 'Unit',
			UNIT_MAJOR				= 0,
			UNIT_MINOR				= 0x100,
		CHUNK_POLYGONAL_DATA		= 'PolH',
			POLYGONAL_DATA_MAJOR	= 0,
			POLYGONAL_DATA_MINOR	= 2,
				FACE_HOLE			= 0x08,
				FACE_BACKCULL		= 0x10,
		CHUNK_MATERIAL				= 'Mat1',
			MATERIAL_MAJOR			= 0,
			MATERIAL_MINOR			= 5,
				ENVMAP_CUBIC		= 0x01,
				ENVMAP_USE			= 0x02,
				TEXTURE_OVERLAY		= 0x01,
				TEXTURE_USE			= 0x02,
				BUMP_USE			= 0x02,
		CHUNK_PROC_TEXTURE			= 'PrTx',
			PROC_TEXTURE_MAJOR		= 0,
			PROC_TEXTURE_MINOR		= 1,
				PROC_GRAIN_R		= 0x01,
				PROC_GRAIN_S		= 0x02,
				PROC_GRAIN_T		= 0x04,
		CHUNK_CAMERA				= 'Came',
			CAMERA_MAJOR			= 0,
			CAMERA_MINOR			= 2,
		CHUNK_CALIMAGE				= 'CImg',
			CALIMAGE_MAJOR			= 0,
			CALIMAGE_MINOR			= 2,
		CHUNK_LIGHT					= 'Lght',
			LIGHT_MAJOR				= 0,
			LIGHT_MINOR				= 5
	};

#define Assert(location, exp)									\
	if (chunk.chunkLen != exp)									\
		throw LAPmismatchLength(location, exp, chunk.chunkLen)


	void					ReadMainChunk();
		void					ReadGroupChunk(CobChunk& );
		void					ReadUnitChunk(CobChunk& );
		void					ReadPolyDataChunk(CobChunk& );
			void					ReadVerticesChunk(pObject* );
			void					ReadMapVerticesChunk(pObject* );
			void					ReadFacesChunk(pObject* );
		void					ReadMaterialChunk(CobChunk& );
			int32					ReadMaterial();
			int32					ReadEnvMapData();
			int32					ReadTextureData();
			int32					ReadBumpMapData();
		void					ReadProcTextureChunk(CobChunk& );
			void					ReadGranitData();
			void					ReadMarbleData();
			void					ReadWoodData();
		void					ReadCameraChunk(CobChunk& );
		void					ReadCalImageChunk(CobChunk& );
		void					ReadLightChunk(CobChunk& );

	void					FixUpFacesMaterial();


	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual void			_Terminate();
	virtual status_t		DoAbort();

public:

							ParserCob(int32 );
	virtual					~ParserCob();
};


#if __POWERPC__
#pragma export on
#endif
extern "C" ParserCob*		instantiate_parser(int32 );
#if __POWERPC__
#pragma export reset
#endif


#endif	/* _PARSER_COB_H_ */

