//
//
//	DXF lexer class
//
//										(C) JoOl 1998


#include "LexerDxf.h"



LexerDxf::LexerDxf(int32 blen, LAPlexemeBuffer* lb)
: LAPtextLexer(blen, lb)
{
}


LexerDxf::~LexerDxf()
{
}


void
LexerDxf::SetLexemes()
{
	lexemes.Insert(new LAPlexeme("SECTION", TOKEN_SECTION));
		lexemes.Insert(new LAPlexeme("HEADER", TOKEN_HEADER));
			lexemes.Insert(new LAPlexeme("$ACADVER", TOKEN_S_ACADVER));
		lexemes.Insert(new LAPlexeme("TABLES", TOKEN_TABLES));
			lexemes.Insert(new LAPlexeme("TABLE", TOKEN_TABLE));
				lexemes.Insert(new LAPlexeme("APPID", TOKEN_APPID));
//				lexemes.Insert(new LAPlexeme("DIMSTYLE", TOKEN_DIMSTYLE));
//				lexemes.Insert(new LAPlexeme("LTYPE", TOKEN_LTYPE));
				lexemes.Insert(new LAPlexeme("LAYER", TOKEN_LAYER));
//				lexemes.Insert(new LAPlexeme("STYLE", TOKEN_STYLE));
//				lexemes.Insert(new LAPlexeme("UCS", TOKEN_UCS));
				lexemes.Insert(new LAPlexeme("VIEW", TOKEN_VIEW));
//				lexemes.Insert(new LAPlexeme("VPORT", TOKEN_VPORT));
			lexemes.Insert(new LAPlexeme("ENDTAB", TOKEN_ENDTAB));
		lexemes.Insert(new LAPlexeme("BLOCKS", TOKEN_BLOCKS));
		lexemes.Insert(new LAPlexeme("ENTITIES", TOKEN_ENTITIES));
			lexemes.Insert(new LAPlexeme("LINE", TOKEN_LINE));
			lexemes.Insert(new LAPlexeme("POINT", TOKEN_POINT));
			lexemes.Insert(new LAPlexeme("VERTEX", TOKEN_VERTEX));
			lexemes.Insert(new LAPlexeme("3DFACE", TOKEN_3DFACE));
			lexemes.Insert(new LAPlexeme("POLYLINE", TOKEN_POLYLINE));
			lexemes.Insert(new LAPlexeme("SEQEND", TOKEN_SEQEND));
	lexemes.Insert(new LAPlexeme("ENDSEC", TOKEN_ENDSEC));
	lexemes.Insert(new LAPlexeme("EOF", TOKEN_EOF));
}


int32
LexerDxf::GetGroupCode()
{
	return groupCode;
}


void
LexerDxf::LexGroup()
{
	LexNumber();
	if (literalType != LAP_INTEGER_LITERAL)
	{
		if (literalType == LAP_FLOAT_LITERAL)
		{
			double			val = GetDoubleLiteral();
			throw LAPmismatchToken("LexerDxf::_NextToken",
										LAP_TOKEN_NUMBER, "<int>",
										token, GetLexeme(token), val);
		}
		else	// if (Lexer->GetLiteralType() == LAP_STRING_LITERAL)
		{
			char*			val = GetStringLiteral();
			throw LAPmismatchToken("LexerDxf::_NextToken",
										LAP_TOKEN_NUMBER, "<int>",
										token, GetLexeme(token), val);
		}
	}
	groupCode = GetInt32Literal();
	lexeme->Reset();
}


void
LexerDxf::ReadLine()
{
	while ((!input->Eof()) && IsSpace(input->Peek()) && (input->Peek() != '\n'))
	{ Skip(); }

	LAPtextLexer::ReadLine();
	char*			line = literal.String;
	if (line[strlen(line)-1] == 0x0d)
		line[strlen(line)-1] = 0;

	if (IsDigit(*line) || (*line == '-'))
		literalType = LAP_INTEGER_LITERAL;
	else if (*line == '.')
		literalType = LAP_FLOAT_LITERAL;
	else
		literalType = LAP_STRING_LITERAL;

	// Check if the lexeme is an integer, a float or a string
	char*			ptr = line;
	while ((*ptr) && (token != LAP_STRING_LITERAL))
	{
		if (literalType == LAP_INTEGER_LITERAL)
		{						// Try to upgrade an integer as a float
			if (*ptr == '-')
			{}
			else if ((*ptr == '.') || (*ptr == 'e') || (*ptr == 'E'))
				literalType = LAP_FLOAT_LITERAL;
			else if (!IsDigit(*ptr))
				literalType = LAP_STRING_LITERAL;
		}
		else		// Try to upgrade a float as a string
		{
			if ((*ptr != '.') && (*ptr != '-') && (*ptr != '+')
			&& (*ptr != 'e') && (*ptr != 'E') && !IsDigit(*ptr))
				literalType = LAP_STRING_LITERAL;
		}
		ptr++;
	}

	if (literalType == LAP_INTEGER_LITERAL)
	{
		token = LAP_TOKEN_NUMBER;
		literal.Int64 = atol(line);
//		if (errno == ERANGE)
//			throw LAPerrorNumRange("LexerDxf::ReadLine", line);
		delete[] line;
	}
	else if (literalType == LAP_FLOAT_LITERAL)
	{
		token = LAP_TOKEN_NUMBER;
		literal.Double = atof(line);
//		if (errno == ERANGE)
//			throw LAPerrorNumRange("LexerDxf::ReadLine", line);
		delete[] line;
	}
	else
	{
		token = LAP_TOKEN_IDENTIFIER;
		literal.String = line;
		// lexeme ?
		LAPlexeme*		Lexm = lexemes.Search(line);
		if (Lexm)
			token = Lexm->GetToken();
	}
}


LAPtoken
LexerDxf::_NextToken()
{
	SkipSpaces();
	if (input->Eof())
	{
		groupCode = 0;
		return TOKEN_EOF;
	}

	LexGroup();
	SkipLine();
	ReadLine();

	return token;
}

