//
//
//	LWOB objects parser
//
//										(C) JoOl 1998


#ifndef _PARSER_LWOB_H_
#define _PARSER_LWOB_H_


#include "LAPbinParser.h"
#include "PierrotParser.h"
#include "LAPerrors.h"
#include "PierrotColor4.h"



class						ParserLwob : public LAPbinParser, public PierrotParser
{
#define ReadChunk										\
	uint32			chunkId;							\
	uint32			chunkLen;							\
	ReadInt32(chunkId);									\
	ReadInt32(chunkLen)

#define ReadSubchunk									\
	uint32			chunkId;							\
	uint16			chunkLen;							\
	ReadInt32(chunkId);									\
	ReadInt16(chunkLen)

#define skipChunk										\
	SkipChunk(chunkId, chunkLen)

#define PadChunk										\
	if (chunkLen & 0x01)								\
	{													\
		SkipBytes(1);									\
		currLen++;										\
	}

#define Assert(location, exp)							\
	if (len != exp)										\
		throw LAPmismatchLength(location, exp, len)

	enum
	{
		CHUNK_FORM				= 'FORM',
		CHUNK_LWOB				= 'LWOB',
		CHUNK_PNTS				= 'PNTS',
		CHUNK_SRFS				= 'SRFS',
		CHUNK_POLS				= 'POLS',
		CHUNK_CRVS				= 'CRVS',
		CHUNK_PCHS				= 'PCHS',
		CHUNK_SURF				= 'SURF',
			SURF_COLOR			= 'COLR',
			SURF_FLAG			= 'FLAG',
				SFLAG_LUMINOUS			= 0x001,
				SFLAG_OUTLINE			= 0x002,
				SFLAG_SMOOTHING			= 0x004,
				SFLAG_COLOR_HIGHLIGHT	= 0x008,
				SFLAG_COLOR_FILTER		= 0x010,
				SFLAG_OPAQUE_EDGE		= 0x020,
				SFLAG_TRANSP_EDGE		= 0x040,
				SFLAG_SHARP_TERM		= 0x080,
				SFLAG_DOUBLE_SIDED		= 0x100,
				SFLAG_ADDITIVE			= 0x200,
				SFLAG_SHADOW_ALPHA		= 0x400,
			SURF_LUMI			= 'LUMI',
			SURF_DIFF			= 'DIFF',
			SURF_SPEC			= 'SPEC',
			SURF_REFL			= 'REFL',
			SURF_TRAN			= 'TRAN',
			SURF_VLUM			= 'VLUM',
			SURF_VDIF			= 'VDIF',
			SURF_VSPC			= 'VSPC',
			SURF_VRFL			= 'VRFL',
			SURF_VTRN			= 'VTRN',
			SURF_GLOS			= 'GLOS',
			SURF_RFLT			= 'RFLT',
			SURF_RIMG			= 'RIMG',
			SURF_RSAN			= 'RSAN',
			SURF_RIND			= 'RIND',
			SURF_EDGE			= 'EDGE',
			SURF_SMAN			= 'SMAN',

			SURF_CTEX			= 'CTEX',
			SURF_DTEX			= 'DTEX',
			SURF_STEX			= 'STEX',
			SURF_RTEX			= 'RTEX',
			SURF_TTEX			= 'TTEX',
			SURF_LTEX			= 'LTEX',
			SURF_BTEX			= 'BTEX',
			SURF_TFLG			= 'TFLG',
			SURF_TSIZ			= 'TSIZ',
			SURF_TCTR			= 'TCTR',
			SURF_TFAL			= 'TFAL',
			SURF_TVEL			= 'TVEL',
			SURF_TCLR			= 'TCLR',
			SURF_TVAL			= 'TVAL',
			SURF_TAMP			= 'TAMP',
			SURF_TFPi			= 'TFP\0',
			SURF_TIPi			= 'TIP\0',
			SURF_TSPi			= 'TSP\0',
			SURF_TFRQ			= 'TFRQ',
			SURF_TIMG			= 'TIMG',
			SURF_TALP			= 'TALP',
			SURF_TWRP			= 'TWRP',
			SURF_TAAS			= 'TAAS',
			SURF_TOPC			= 'TOPC',

			SURF_SHDR			= 'SHDR',
			SURF_SDAT			= 'SDAT',
			SURF_IMSQ			= 'IMSQ',
			SURF_FLYR			= 'FLYR',
			SURF_IMCC			= 'IMCC'
	};

	void					ParsePoint(pPoint3& );
	void					ParseColor(pSpectra& );
	void					ParseIpercentage(float& );
	char*					ParseName();
	uint32					ParsePadName(char*& );
	void					SkipChunk(uint32 , uint32 );

	void					ReadMainChunk(uint32 );
		void					ReadPointsChunk(uint32 , pObject* );
		void					ReadSurfacesListChunk(uint32 );
		void					ReadFacesListChunk(uint32 , pObject* );
			uint32					ReadDetailPolygonChunk();
		void					ReadSurfaceChunk(uint32 );


	virtual status_t		_Identify();
	virtual status_t		_Parse();
	virtual void			_Terminate();
	virtual status_t		DoAbort();

public:

							ParserLwob(int32 );
	virtual					~ParserLwob();
};


#if __POWERPC__
#pragma export on
#endif
extern "C" ParserLwob*		instantiate_parser(int32 );
#if __POWERPC__
#pragma export reset
#endif


#endif	/* _PARSER_LWOB_H_ */

