//
//
//	NFF lexer class
//
//										(C) JoOl 1998


#include "LexerNff.h"



LexerNff::LexerNff(int32 blen, LAPlexemeBuffer* lb)
: LAPtextLexer(blen, lb)
{
}


LexerNff::~LexerNff()
{
}


void
LexerNff::SetLexemes()
{
	lexemes.Insert(new LAPlexeme("v", TOKEN_VIEW));
		lexemes.Insert(new LAPlexeme("from", TOKEN_FROM));
		lexemes.Insert(new LAPlexeme("at", TOKEN_AT));
		lexemes.Insert(new LAPlexeme("up", TOKEN_UP));
		lexemes.Insert(new LAPlexeme("angle", TOKEN_ANGLE));
		lexemes.Insert(new LAPlexeme("hither", TOKEN_HITHER));
		lexemes.Insert(new LAPlexeme("resolution", TOKEN_RESOLUTION));

	lexemes.Insert(new LAPlexeme("b", TOKEN_BACKGROUND));
	lexemes.Insert(new LAPlexeme("l", TOKEN_LIGHT));
	lexemes.Insert(new LAPlexeme("f", TOKEN_MATERIAL));
	lexemes.Insert(new LAPlexeme("c", TOKEN_CONE));
	lexemes.Insert(new LAPlexeme("s", TOKEN_SPHERE));
	lexemes.Insert(new LAPlexeme("p", TOKEN_POLYGON));
	lexemes.Insert(new LAPlexeme("pp", TOKEN_PATCH));
	//--
	lexemes.Insert(new LAPlexeme("torus", TOKEN_TORUS));
	lexemes.Insert(new LAPlexeme("ring", TOKEN_RING));
	lexemes.Insert(new LAPlexeme("prism", TOKEN_PRISM));
}


LAPtoken
LexerNff::_NextToken()
{
	for (;;)
	{
		if (input->Eof())
			return LAP_TOKEN_EOF;

		char			currentCharacter = input->Peek();

		// deal with numbers (both positive and negative integers or floats)
		if (IsDigit(currentCharacter) || (currentCharacter == '.'))
		{
			LexNumber();
			return token;
		}
		if (currentCharacter == '-')
		{
			Fwd();
			LexNumber();
			return token;
		}

		// deal with identifiers and lexemes
		if (IsAlpha(currentCharacter))
		{
			LexIdentifier();
			return token;
		}

		// deal with spaces
		if (IsSpace(currentCharacter))
		{
			SkipSpaces();
			continue;
		}

		if (currentCharacter == '#')
		{
			SkipLine();
			continue;
		}

		ProcessIllegal(currentCharacter);
	}
}

